/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.ratelimit.ConcurrentWorker;
import org.opensearch.timeseries.ratelimit.QueuedRequest;

public abstract class SingleRequestWorker<RequestType extends QueuedRequest>
extends ConcurrentWorker<RequestType> {
    private static final Logger LOG = LogManager.getLogger(SingleRequestWorker.class);

    public SingleRequestWorker(String queueName, long heapSize, int singleRequestSize, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, CircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, String threadPoolName, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, Setting<Integer> concurrencySetting, Duration executionTtl, Duration stateTtl, NodeStateManager nodeStateManager, AnalysisType context) {
        super(queueName, heapSize, singleRequestSize, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, threadPoolName, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, concurrencySetting, executionTtl, stateTtl, nodeStateManager, context);
    }

    @Override
    protected void execute(Runnable afterProcessCallback, Runnable emptyQueueCallback) {
        String configId;
        QueuedRequest request = null;
        Optional queueOptional = this.selectNextQueue();
        if (!queueOptional.isPresent()) {
            emptyQueueCallback.run();
            return;
        }
        BlockingQueue queue = queueOptional.get();
        if (!queue.isEmpty() && (request = (QueuedRequest)queue.poll()) != null && (configId = request.getConfigId()) != null) {
            this.inflightConfigs.add(configId);
        }
        if (request == null) {
            emptyQueueCallback.run();
            return;
        }
        ActionListener handlerWithRelease = ActionListener.wrap((Runnable)afterProcessCallback);
        String inflightConfigId = request.getConfigId();
        this.executeRequest(request, (ActionListener<Void>)ActionListener.runAfter((ActionListener)handlerWithRelease, () -> {
            if (inflightConfigId != null) {
                this.inflightConfigs.remove(inflightConfigId);
            }
        }));
    }

    protected abstract void executeRequest(RequestType var1, ActionListener<Void> var2);
}

