/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.runnable;

import org.opensearch.telemetry.tracing.ScopedSpan;
import org.opensearch.telemetry.tracing.SpanCreationContext;
import org.opensearch.telemetry.tracing.Tracer;

public class TraceableRunnable
implements Runnable {
    private final Runnable runnable;
    private final SpanCreationContext spanCreationContext;
    private final Tracer tracer;

    public TraceableRunnable(Tracer tracer, SpanCreationContext spanCreationContext, Runnable runnable) {
        this.tracer = tracer;
        this.spanCreationContext = spanCreationContext;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        try (ScopedSpan spanScope = this.tracer.startScopedSpan(this.spanCreationContext);){
            this.runnable.run();
        }
    }
}

