/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.time.Duration;
import java.util.EnumMap;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.jdbc.BorrowContext;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.util.OpaqueString;

public class BorrowContextUpdater
implements BorrowContext {
    private final EnumMap<Key, Object> context;
    private static final Runnable EMPTY_EQUALITY_CHANGE_TRIGGER = () -> {};
    private volatile Runnable equalityChangeTrigger = EMPTY_EQUALITY_CHANGE_TRIGGER;

    public void registerEqualityChangeTrigger(Runnable trigger) {
        this.equalityChangeTrigger = trigger;
    }

    public BorrowContextUpdater() {
        this.context = new EnumMap(Key.class);
    }

    public BorrowContextUpdater(BorrowContextUpdater updater) {
        this.context = new EnumMap<Key, Object>(updater.context);
    }

    public BorrowContextUpdater user(String user) {
        if (null == user) {
            this.context.remove((Object)Key.USER);
        } else {
            this.context.put(Key.USER, (Object)user);
        }
        this.equalityChangeTrigger.run();
        return this;
    }

    public BorrowContextUpdater password(OpaqueString password) {
        if (null == password) {
            this.context.remove((Object)Key.PASSWORD);
        } else {
            this.context.put(Key.PASSWORD, (Object)password);
        }
        this.equalityChangeTrigger.run();
        return this;
    }

    public BorrowContextUpdater labels(Properties labels) {
        if (null == labels) {
            this.context.remove((Object)Key.LABELS);
        } else {
            this.context.put(Key.LABELS, (Object)labels);
        }
        return this;
    }

    public BorrowContextUpdater serviceName(String serviceName) {
        if (null == serviceName) {
            this.context.remove((Object)Key.SERVICE_NAME);
        } else {
            this.context.put(Key.SERVICE_NAME, (Object)serviceName);
        }
        this.equalityChangeTrigger.run();
        return this;
    }

    public BorrowContextUpdater userRequestedServiceName(String serviceName) {
        if (null == serviceName) {
            this.context.remove((Object)Key.USER_REQUESTED_SERVICE_NAME);
        } else {
            this.context.put(Key.USER_REQUESTED_SERVICE_NAME, (Object)serviceName);
        }
        return this;
    }

    public BorrowContextUpdater proxyProperties(int proxyType, Properties proxyProperties) {
        this.context.put(Key.PROXY_TYPE, (Object)proxyType);
        this.context.put(Key.PROXY_PROPERTIES, (Object)proxyProperties);
        return this;
    }

    public BorrowContextUpdater shardingKey(OracleShardingKey shardingKey) {
        if (null == shardingKey) {
            this.context.remove((Object)Key.SHARDING_KEY);
        } else {
            this.context.put(Key.SHARDING_KEY, (Object)shardingKey);
        }
        return this;
    }

    public BorrowContextUpdater superShardingKey(OracleShardingKey superShardingKey) {
        if (null == superShardingKey) {
            this.context.remove((Object)Key.SUPER_SHARDING_KEY);
        } else {
            ((OracleShardingKeyImpl)superShardingKey).markSuperShardingKey(true);
            this.context.put(Key.SUPER_SHARDING_KEY, (Object)superShardingKey);
        }
        return this;
    }

    public BorrowContextUpdater lookupShardingKey(OracleShardingKey shardingKey) {
        if (null == shardingKey) {
            this.context.remove((Object)Key.LOOKUP_SHARDING_KEY);
        } else {
            this.context.put(Key.LOOKUP_SHARDING_KEY, (Object)shardingKey);
        }
        return this;
    }

    public BorrowContextUpdater pdbRoles(Properties pdbRoles) {
        this.context.put(Key.PDB_ROLES, (Object)pdbRoles);
        return this;
    }

    public BorrowContextUpdater sslContext(SSLContext sslContext) {
        if (null == sslContext) {
            this.context.remove((Object)Key.SSL_CONTEXT);
        } else {
            this.context.put(Key.SSL_CONTEXT, (Object)sslContext);
        }
        return this;
    }

    public BorrowContextUpdater hostnameResolver(PoolDataSource.HostnameResolver hostnameResolver) {
        if (null == hostnameResolver) {
            this.context.remove((Object)Key.HOSTNAME_RESOLVER);
        } else {
            this.context.put(Key.HOSTNAME_RESOLVER, (Object)hostnameResolver);
        }
        return this;
    }

    public BorrowContextUpdater readOnlyInstanceAllowed(Boolean readOnlyInstanceAllowed) {
        if (null == readOnlyInstanceAllowed) {
            this.context.remove((Object)Key.READ_ONLY_INSTANCE_ALLOWED);
        } else {
            this.context.put(Key.READ_ONLY_INSTANCE_ALLOWED, (Object)readOnlyInstanceAllowed);
        }
        return this;
    }

    public BorrowContextUpdater connectionWaitDuration(Duration connectionWaitDuration) {
        if (null == connectionWaitDuration) {
            this.context.remove((Object)Key.CONNECTION_WAIT_DURATION_IN_MILLIS);
        } else {
            if (connectionWaitDuration.isNegative()) {
                throw new IllegalArgumentException("connection wait duration should be 0 or positive");
            }
            this.context.put(Key.CONNECTION_WAIT_DURATION_IN_MILLIS, (Object)connectionWaitDuration.toMillis());
        }
        return this;
    }

    @Override
    public String getUser() {
        return (String)this.context.get((Object)Key.USER);
    }

    @Override
    public OpaqueString getPassword() {
        return (OpaqueString)this.context.get((Object)Key.PASSWORD);
    }

    @Override
    public Properties getLabels() {
        return (Properties)this.context.get((Object)Key.LABELS);
    }

    @Override
    public String getServiceName() {
        return (String)this.context.get((Object)Key.SERVICE_NAME);
    }

    @Override
    public String getUserRequestedServiceName() {
        return (String)this.context.get((Object)Key.USER_REQUESTED_SERVICE_NAME);
    }

    @Override
    public OracleShardingKey getShardingKey() {
        return (OracleShardingKey)this.context.get((Object)Key.SHARDING_KEY);
    }

    @Override
    public OracleShardingKey getSuperShardingKey() {
        return (OracleShardingKey)this.context.get((Object)Key.SUPER_SHARDING_KEY);
    }

    @Override
    public OracleShardingKey getLookupShardingKey() {
        return (OracleShardingKey)this.context.get((Object)Key.LOOKUP_SHARDING_KEY);
    }

    @Override
    public Properties getProxyProperties() {
        return (Properties)this.context.get((Object)Key.PROXY_PROPERTIES);
    }

    @Override
    public Integer getProxyType() {
        Integer res = (Integer)this.context.get((Object)Key.PROXY_TYPE);
        if (null == res) {
            return -1;
        }
        return res;
    }

    @Override
    public Properties getPdbRoles() {
        return (Properties)this.context.get((Object)Key.PDB_ROLES);
    }

    @Override
    public SSLContext getSSLContext() {
        return (SSLContext)this.context.get((Object)Key.SSL_CONTEXT);
    }

    @Override
    public PoolDataSource.HostnameResolver getHostnameResolver() {
        return (PoolDataSource.HostnameResolver)this.context.get((Object)Key.HOSTNAME_RESOLVER);
    }

    @Override
    public Boolean isReadOnlyInstanceAllowed() {
        return (Boolean)this.context.get((Object)Key.READ_ONLY_INSTANCE_ALLOWED);
    }

    @Override
    public Duration getConnectionWaitDuration() {
        Long connectionWaitDurationInMillis = this.getConnectionWaitDurationInMillis();
        if (null == connectionWaitDurationInMillis) {
            return null;
        }
        return Duration.ofMillis(connectionWaitDurationInMillis);
    }

    @Override
    public Long getConnectionWaitDurationInMillis() {
        return (Long)this.context.get((Object)Key.CONNECTION_WAIT_DURATION_IN_MILLIS);
    }

    public JDBCConnectionRetrievalInfo build() {
        return new JDBCConnectionRetrievalInfo(new BorrowContext(){}, this);
    }

    static enum Key {
        USER,
        PASSWORD,
        LABELS,
        SERVICE_NAME,
        USER_REQUESTED_SERVICE_NAME,
        PROXY_TYPE,
        PROXY_PROPERTIES,
        SHARDING_KEY,
        SUPER_SHARDING_KEY,
        LOOKUP_SHARDING_KEY,
        PDB_ROLES,
        SSL_CONTEXT,
        HOSTNAME_RESOLVER,
        READ_ONLY_INSTANCE_ALLOWED,
        CONNECTION_WAIT_DURATION_IN_MILLIS;

    }
}

