<?php

declare (strict_types=1);
namespace OCA\News\Vendor\FeedIo\Standard;

use DOMDocument;
use OCA\News\Vendor\FeedIo\Reader\Document;
use OCA\News\Vendor\FeedIo\Rule\Atom\Author;
use OCA\News\Vendor\FeedIo\Rule\Atom\Content;
use OCA\News\Vendor\FeedIo\Rule\Atom\LinkNode;
use OCA\News\Vendor\FeedIo\Rule\Atom\Logo;
use OCA\News\Vendor\FeedIo\Rule\Atom\Summary;
use OCA\News\Vendor\FeedIo\Rule\Description;
use OCA\News\Vendor\FeedIo\Rule\Language;
use OCA\News\Vendor\FeedIo\Rule\Media;
use OCA\News\Vendor\FeedIo\Rule\PublicId;
use OCA\News\Vendor\FeedIo\Rule\Atom\Category;
use OCA\News\Vendor\FeedIo\RuleSet;
class Atom extends XmlAbstract
{
    public const ROOT_NODE_TAGNAME = 'feed';
    public const ITEM_NODE = 'entry';
    public const DATETIME_FORMAT = \DateTime::ATOM;
    public const MIME_TYPE = 'application/atom+xml';
    public function format(DOMDocument $document): DOMDocument
    {
        $element = $document->createElement('feed');
        $element->setAttribute('xmlns', 'http://www.w3.org/2005/Atom');
        $document->appendChild($element);
        return $document;
    }
    public function canHandle(Document $document): bool
    {
        if (!isset($document->getDOMDocument()->documentElement->tagName)) {
            return \false;
        }
        return self::ROOT_NODE_TAGNAME === $document->getDOMDocument()->documentElement->tagName;
    }
    public function getMainElement(\DOMDocument $document): \DOMElement
    {
        return $document->documentElement;
    }
    public function buildFeedRuleSet(): RuleSet
    {
        $ruleSet = $this->buildBaseRuleSet();
        $ruleSet->add(new Logo())->add(new Description());
        return $ruleSet;
    }
    public function buildItemRuleSet(): RuleSet
    {
        $ruleSet = $this->buildBaseRuleSet();
        $ruleSet->add(new Content())->add(new Summary())->add(new Media(), ['media:group', 'media:content']);
        return $ruleSet;
    }
    protected function buildBaseRuleSet(): RuleSet
    {
        $ruleSet = parent::buildBaseRuleSet();
        $ruleSet->add(new Category())->add(new Author())->add(new LinkNode())->add(new PublicId('id'))->add(new Language('lang'))->add($this->getModifiedSinceRule('updated'), ['published']);
        return $ruleSet;
    }
}
