/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.util;

import java.util.concurrent.TimeUnit;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.utils.SessionExpiration;
import org.keycloak.models.utils.SessionExpirationUtils;

public class SessionTimeouts {
    public static final long ENTRY_EXPIRED_FLAG = -2L;
    private static final long IMMORTAL_FLAG = -1L;

    public static long getUserSessionLifespanMs(RealmModel realm, ClientModel client, UserSessionEntity userSessionEntity) {
        return SessionTimeouts.getUserSessionLifespanMs(realm, false, userSessionEntity.isRememberMe(), userSessionEntity.getStarted());
    }

    public static long getUserSessionLifespanMs(RealmModel realm, boolean offline, boolean rememberMe, int started) {
        long lifespan = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp((boolean)offline, (boolean)rememberMe, (long)TimeUnit.SECONDS.toMillis(started), (RealmModel)realm);
        if (offline && lifespan == -1L) {
            return -1L;
        }
        if ((lifespan -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return lifespan;
    }

    public static long getUserSessionMaxIdleMs(RealmModel realm, ClientModel client, UserSessionEntity userSessionEntity) {
        return SessionTimeouts.getUserSessionMaxIdleMs(realm, false, userSessionEntity.isRememberMe(), userSessionEntity.getLastSessionRefresh());
    }

    public static long getUserSessionMaxIdleMs(RealmModel realm, boolean offline, boolean rememberMe, int lastSessionRefresh) {
        long idle = SessionExpirationUtils.calculateUserSessionIdleTimestamp((boolean)offline, (boolean)rememberMe, (long)TimeUnit.SECONDS.toMillis(lastSessionRefresh), (RealmModel)realm);
        if ((idle -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return idle;
    }

    public static long getClientSessionLifespanMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity clientSessionEntity) {
        return SessionTimeouts.getClientSessionLifespanMs(realm, client, false, clientSessionEntity.isUserSessionRememberMe(), clientSessionEntity.getStarted(), clientSessionEntity.getUserSessionStarted());
    }

    public static long getClientSessionLifespanMs(RealmModel realm, ClientModel client, boolean offline, boolean isUserSessionRememberMe, int started, int userSessionStarted) {
        long lifespan = SessionExpirationUtils.calculateClientSessionMaxLifespanTimestamp((boolean)offline, (boolean)isUserSessionRememberMe, (long)TimeUnit.SECONDS.toMillis(started), (long)TimeUnit.SECONDS.toMillis(userSessionStarted), (RealmModel)realm, (ClientModel)client);
        if (offline && lifespan == -1L) {
            return -1L;
        }
        if ((lifespan -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return lifespan;
    }

    public static long getClientSessionMaxIdleMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity clientSessionEntity) {
        return SessionTimeouts.getClientSessionMaxIdleMs(realm, client, false, clientSessionEntity.isUserSessionRememberMe(), clientSessionEntity.getTimestamp());
    }

    public static long getClientSessionMaxIdleMs(RealmModel realm, ClientModel client, boolean offline, boolean isUserSessionRememberMe, int timestamp) {
        long idle = SessionExpirationUtils.calculateClientSessionIdleTimestamp((boolean)offline, (boolean)isUserSessionRememberMe, (long)TimeUnit.SECONDS.toMillis(timestamp), (RealmModel)realm, (ClientModel)client);
        if ((idle -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return idle;
    }

    public static long getOfflineSessionLifespanMs(RealmModel realm, ClientModel client, UserSessionEntity userSessionEntity) {
        return SessionTimeouts.getUserSessionLifespanMs(realm, true, userSessionEntity.isRememberMe(), userSessionEntity.getStarted());
    }

    public static long getOfflineSessionMaxIdleMs(RealmModel realm, ClientModel client, UserSessionEntity userSessionEntity) {
        return SessionTimeouts.getUserSessionMaxIdleMs(realm, true, userSessionEntity.isRememberMe(), userSessionEntity.getLastSessionRefresh());
    }

    public static long getOfflineClientSessionLifespanMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity authenticatedClientSessionEntity) {
        return SessionTimeouts.getClientSessionLifespanMs(realm, client, true, authenticatedClientSessionEntity.isUserSessionRememberMe(), authenticatedClientSessionEntity.getStarted(), authenticatedClientSessionEntity.getUserSessionStarted());
    }

    public static long getOfflineClientSessionMaxIdleMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity authenticatedClientSessionEntity) {
        return SessionTimeouts.getClientSessionMaxIdleMs(realm, client, true, authenticatedClientSessionEntity.isUserSessionRememberMe(), authenticatedClientSessionEntity.getTimestamp());
    }

    public static long getLoginFailuresLifespanMs(RealmModel realm, ClientModel client, LoginFailureEntity loginFailureEntity) {
        return SessionTimeouts.getLoginFailuresLifespanMs(realm.isPermanentLockout(), realm.getMaxTemporaryLockouts(), (long)realm.getMaxDeltaTimeSeconds() * 1000L, loginFailureEntity);
    }

    public static long getLoginFailuresLifespanMs(boolean isPermanentLockout, int maxTemporaryLockouts, long maxDeltaTimeMillis, LoginFailureEntity loginFailureEntity) {
        if (loginFailureEntity.getLastFailure() == 0L) {
            return 0L;
        }
        if (isPermanentLockout && maxTemporaryLockouts == 0) {
            return -1L;
        }
        return Math.max(0L, maxDeltaTimeMillis - (Time.currentTimeMillis() - loginFailureEntity.getLastFailure()));
    }

    public static long getLoginFailuresMaxIdleMs(RealmModel realm, ClientModel client, LoginFailureEntity loginFailureEntity) {
        return -1L;
    }

    public static long getAuthSessionLifespanMS(RealmModel realm, ClientModel client, RootAuthenticationSessionEntity entity) {
        return (long)(entity.getTimestamp() - Time.currentTime() + SessionExpiration.getAuthSessionLifespan((RealmModel)realm)) * 1000L;
    }

    public static long getAuthSessionMaxIdleMS(RealmModel realm, ClientModel client, RootAuthenticationSessionEntity entity) {
        return -1L;
    }
}

