/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.List;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.valid.PolygonTopologyAnalyzer;

class IndexedNestedPolygonTester {
    private MultiPolygon multiPoly;
    private SpatialIndex index;
    private IndexedPointInAreaLocator[] locators;
    private Coordinate nestedPt;

    public IndexedNestedPolygonTester(MultiPolygon multiPoly) {
        this.multiPoly = multiPoly;
        this.loadIndex();
    }

    private void loadIndex() {
        this.index = new STRtree();
        for (int i = 0; i < this.multiPoly.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)this.multiPoly.getGeometryN(i);
            Envelope env = poly.getEnvelopeInternal();
            this.index.insert(env, i);
        }
    }

    private IndexedPointInAreaLocator getLocator(int polyIndex) {
        IndexedPointInAreaLocator locator;
        if (this.locators == null) {
            this.locators = new IndexedPointInAreaLocator[this.multiPoly.getNumGeometries()];
        }
        if ((locator = this.locators[polyIndex]) == null) {
            this.locators[polyIndex] = locator = new IndexedPointInAreaLocator(this.multiPoly.getGeometryN(polyIndex));
        }
        return locator;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNested() {
        for (int i = 0; i < this.multiPoly.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)this.multiPoly.getGeometryN(i);
            LinearRing shell = poly.getExteriorRing();
            List results = this.index.query(poly.getEnvelopeInternal());
            for (Integer polyIndex : results) {
                Polygon possibleOuterPoly = (Polygon)this.multiPoly.getGeometryN(polyIndex);
                if (poly == possibleOuterPoly || !possibleOuterPoly.getEnvelopeInternal().covers(poly.getEnvelopeInternal())) continue;
                this.nestedPt = this.findNestedPoint(shell, possibleOuterPoly, this.getLocator(polyIndex));
                if (this.nestedPt == null) continue;
                return true;
            }
        }
        return false;
    }

    private Coordinate findNestedPoint(LinearRing shell, Polygon possibleOuterPoly, IndexedPointInAreaLocator locator) {
        Coordinate shellPt0 = shell.getCoordinateN(0);
        int loc0 = locator.locate(shellPt0);
        if (loc0 == 2) {
            return null;
        }
        if (loc0 == 0) {
            return shellPt0;
        }
        Coordinate shellPt1 = shell.getCoordinateN(1);
        int loc1 = locator.locate(shellPt1);
        if (loc1 == 2) {
            return null;
        }
        if (loc1 == 0) {
            return shellPt1;
        }
        return IndexedNestedPolygonTester.findIncidentSegmentNestedPoint(shell, possibleOuterPoly);
    }

    private static Coordinate findIncidentSegmentNestedPoint(LinearRing shell, Polygon poly) {
        LinearRing polyShell = poly.getExteriorRing();
        if (polyShell.isEmpty()) {
            return null;
        }
        if (!PolygonTopologyAnalyzer.isRingNested(shell, polyShell)) {
            return null;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            if (!hole.getEnvelopeInternal().covers(shell.getEnvelopeInternal()) || !PolygonTopologyAnalyzer.isRingNested(shell, hole)) continue;
            return null;
        }
        return shell.getCoordinateN(0);
    }
}

