/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.dictionary.Loader;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class FileLoader
implements Loader {
    private final String url;
    private final String name;

    public FileLoader(String url, String name) {
        this.url = url;
        this.name = name;
    }

    public FileLoader(String url) {
        this(url, url);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load(@NotNull Consumer<String> consumer) {
        VirtualFile file;
        if (consumer == null) {
            FileLoader.$$$reportNull$$$0(0);
        }
        if ((file = VfsUtil.findFileByIoFile((File)new File(this.url), (boolean)true)) == null || file.isDirectory()) {
            return;
        }
        Charset charset = file.getCharset();
        try (InputStream stream = file.getInputStream();
             BufferedReader br = new BufferedReader(new InputStreamReader(stream, charset));){
            br.lines().forEach(consumer);
        }
        catch (CancellationException exception) {
            throw exception;
        }
        catch (Exception e) {
            Logger.getInstance(FileLoader.class).error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/FileLoader", "load"));
    }
}

