/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.impl.TypeCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public abstract class GroovyConstructorNamedArgumentProvider
extends GroovyNamedArgumentProvider {
    private static final String METACLASS = "metaClass";

    @NotNull
    public abstract List<PsiClass> getCorrespondingClasses(@NotNull GrCall var1, @NotNull GroovyResolveResult var2);

    @Override
    public void getNamedArguments(@NotNull GrCall call, @NotNull GroovyResolveResult resolveResult, @Nullable String argumentName, boolean forCompletion, @NotNull Map<String, NamedArgumentDescriptor> result2) {
        GrArgumentList argumentList;
        if (call == null) {
            GroovyConstructorNamedArgumentProvider.$$$reportNull$$$0(0);
        }
        if (resolveResult == null) {
            GroovyConstructorNamedArgumentProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            GroovyConstructorNamedArgumentProvider.$$$reportNull$$$0(2);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return;
        }
        GrExpression[] expressionArguments = argumentList.getExpressionArguments();
        if (expressionArguments.length > 1 || expressionArguments.length == 1 && !(expressionArguments[0] instanceof GrReferenceExpression)) {
            return;
        }
        if (!PsiUtil.isTrustedMapConstructorResult(resolveResult)) {
            return;
        }
        for (PsiClass psiClass : this.getCorrespondingClasses(call, resolveResult)) {
            if (!GroovyConstructorNamedArgumentProvider.isClassHasConstructorWithMap(psiClass)) continue;
            PsiClassType classType = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
            GroovyConstructorNamedArgumentProvider.processClass(call, classType, argumentName, result2);
        }
    }

    public static void processClass(@NotNull GrCall call, PsiClassType type, @Nullable String argumentName, final Map<String, NamedArgumentDescriptor> result2) {
        if (call == null) {
            GroovyConstructorNamedArgumentProvider.$$$reportNull$$$0(3);
        }
        if (argumentName == null) {
            final HashMap map2 = new HashMap();
            MyPsiScopeProcessor processor = new MyPsiScopeProcessor(){

                @Override
                protected void addNamedArgument(String propertyName, PsiType type, PsiElement element, PsiSubstitutor substitutor) {
                    if (result2.containsKey(propertyName)) {
                        return;
                    }
                    Trinity pair = (Trinity)map2.get(propertyName);
                    if (!(pair == null || element instanceof PsiMethod && pair.second instanceof PsiField)) {
                        return;
                    }
                    map2.put(propertyName, Trinity.create((Object)type, (Object)element, (Object)substitutor));
                }
            };
            processor.setResolveTargetKinds(ClassHint.RESOLVE_KINDS_METHOD_PROPERTY);
            ResolveUtil.processAllDeclarations((PsiType)type, (PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)call);
            for (Map.Entry entry : map2.entrySet()) {
                result2.put((String)entry.getKey(), new TypeCondition((PsiType)((Trinity)entry.getValue()).first, (PsiElement)((Trinity)entry.getValue()).getSecond(), (PsiSubstitutor)((Trinity)entry.getValue()).getThird(), NamedArgumentDescriptor.Priority.AS_LOCAL_VARIABLE));
            }
        } else {
            MyPsiScopeProcessor processor = new MyPsiScopeProcessor(){

                @Override
                protected void addNamedArgument(String propertyName, PsiType type, PsiElement element, PsiSubstitutor substitutor) {
                    if (result2.containsKey(propertyName)) {
                        return;
                    }
                    result2.put(propertyName, new TypeCondition(type, element, substitutor, NamedArgumentDescriptor.Priority.AS_LOCAL_VARIABLE));
                }
            };
            processor.setResolveTargetKinds(ClassHint.RESOLVE_KINDS_METHOD);
            processor.setNameHint(GroovyPropertyUtils.getSetterName(argumentName));
            ResolveUtil.processAllDeclarations((PsiType)type, (PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)call);
            processor.setResolveTargetKinds(ClassHint.RESOLVE_KINDS_PROPERTY);
            processor.setNameHint(argumentName);
            ResolveUtil.processAllDeclarations((PsiType)type, (PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)call);
        }
    }

    public static boolean isClassHasConstructorWithMap(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            PsiParameterList parameterList = constructor.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return true;
            }
            PsiParameter first = parameters[0];
            if (InheritanceUtil.isInheritor((PsiType)first.getType(), (String)"java.util.Map")) {
                return true;
            }
            if (first instanceof GrParameter && ((GrParameter)first).getTypeGroovy() == null) {
                return true;
            }
            if (PsiUtil.isConstructorHasRequiredParameters(constructor)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/GroovyConstructorNamedArgumentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamedArguments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class MyPsiScopeProcessor
    implements PsiScopeProcessor,
    NameHint,
    ClassHint,
    ElementClassHint {
        private String myNameHint;
        private EnumSet<ElementClassHint.DeclarationKind> myResolveTargetKinds;

        private MyPsiScopeProcessor() {
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                MyPsiScopeProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                MyPsiScopeProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiMethod || element instanceof PsiField) {
                PsiType type;
                String propertyName;
                if (element instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)element;
                    if (!this.myResolveTargetKinds.contains(ElementClassHint.DeclarationKind.METHOD)) {
                        return true;
                    }
                    if (!GroovyPropertyUtils.isSimplePropertySetter(method)) {
                        return true;
                    }
                    propertyName = GroovyPropertyUtils.getPropertyNameBySetter(method);
                    if (propertyName == null) {
                        return true;
                    }
                    type = method.getParameterList().getParameters()[0].getType();
                } else {
                    if (!this.myResolveTargetKinds.contains(ElementClassHint.DeclarationKind.FIELD)) {
                        return true;
                    }
                    type = ((PsiField)element).getType();
                    propertyName = ((PsiField)element).getName();
                }
                if (GroovyConstructorNamedArgumentProvider.METACLASS.equals(propertyName)) {
                    return true;
                }
                PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
                if (substitutor != null) {
                    type = substitutor.substitute(type);
                }
                this.addNamedArgument(propertyName, type, element, substitutor);
            }
            return true;
        }

        protected abstract void addNamedArgument(String var1, PsiType var2, PsiElement var3, PsiSubstitutor var4);

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                MyPsiScopeProcessor.$$$reportNull$$$0(2);
            }
            if (NameHint.KEY == hintKey && this.myNameHint != null || ElementClassHint.KEY == hintKey) {
                return (T)this;
            }
            return null;
        }

        public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
            if (kind == null) {
                MyPsiScopeProcessor.$$$reportNull$$$0(3);
            }
            return this.myResolveTargetKinds.contains(kind);
        }

        public String getName(@NotNull ResolveState state) {
            if (state == null) {
                MyPsiScopeProcessor.$$$reportNull$$$0(4);
            }
            return this.myNameHint;
        }

        public void setNameHint(String nameHint) {
            this.myNameHint = nameHint;
        }

        public void setResolveTargetKinds(EnumSet<ElementClassHint.DeclarationKind> resolveTargetKinds) {
            this.myResolveTargetKinds = resolveTargetKinds;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintKey";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/lang/GroovyConstructorNamedArgumentProvider$MyPsiScopeProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHint";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldProcess";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

