# Copyright (C) 2023 Intel Corporation
# SPDX-License-Identifier: MIT

import sys


class UnsupportedPythonVersionError(Exception):
    def __init__(self, supported_versions):
        self.supported_versions = supported_versions
        super().__init__(f'Unsupported Python version. Supported Python versions include : {supported_versions}')

class SupportedPythonVersions:
    VERSIONS = ['3.9', '3.10', '3.11', '3.12', '3.13']

    def __str__(self):
        return ", ".join(f"'{v}'" for v in self.VERSIONS)

class PythonVersion:
    SUPPORTED_VERSIONS = SupportedPythonVersions.VERSIONS

    @staticmethod
    def get_version():
        version_info = sys.version_info
        python_version = f"{version_info.major}.{version_info.minor}"
        if python_version in PythonVersion.SUPPORTED_VERSIONS:
            return python_version
        raise UnsupportedPythonVersionError(PythonVersion.SUPPORTED_VERSIONS)

    @staticmethod
    def is_supported():
        try:
            PythonVersion.get_version()
            return True
        except UnsupportedPythonVersionError:
            return False

