<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="msxsl"
                xmlns:exsl="http://exslt.org/common"
                xmlns:int="http://www.w3.org/2001/XMLSchema#int"
                xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
                exsl:keep_exsl_namespace=""
                syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="tCount"/>
  <xsl:param name="sCount"/>
  <xsl:param name="dssCount"/>
  <xsl:param name="euCount"/>
  <xsl:template match="/">
    <diagram>
      <xsl:attribute name="id">ATS<xsl:value-of select="$tCount"/>x<xsl:value-of select="$sCount"/>x<xsl:value-of select="$dssCount"/>x<xsl:value-of select="$euCount"/></xsl:attribute>
      <graph>
        <node id = "gpu">
          <node id="tile">
            <node id="slice">
              <node id="dss">
                <node id = "euArray"/>
                <node id = "sampler">
                  <node id="l1"/>
                  <node id="l2"/>
                </node>
                <node id = "slm"/>
              </node>
              <node id="l3"/>
            </node>
          </node>
          <node id="HBM"/>
        </node>
        <node id="pcie"/>
        <node id="uncore">
          <node id="llc"/>
        </node>
        <node id="system">
          <node id="dram"/>
        </node>
        <node id = "cpu">
          <node id="cpuCores"/>
        </node>
        <link id="euArray_slm" from="euArray" to="slm" direction="both"/>
        <link id="sampler_l3" from="sampler" to="l3" direction="back"/>
        <link id="euArray_l3" from="euArray" to="l3" direction="both"/>
        <link id="euArray_sampler" from="euArray" to="sampler" direction="back"/>
        <link id="l3_HBM" from="l3" to="HBM" direction="both"/>
        <link id="l3_pcie" from="l3" to="pcie" direction="both"/>
        <link id="pcie_llc" from="pcie" to="llc" direction="both"/>
        <link id="cpu_llc" from="cpu" to="llc" direction="both"/>
        <link id="llc_dram" from="llc" to="dram" direction="both"/>
      </graph>
      <display>
        <layout id="hierarchical" boolean:routeLinks="true" boolean:doPostprocessing="true" boolean:zoomToFit="false"/>
        <node id="tile" displayName="%tile" type="multiDevice" color="#EAEAEA" textColor="#666666">
          <xsl:attribute name="count">%Total: <xsl:value-of select="$tCount"/></xsl:attribute>
        </node>
        <node id="gpu" displayName="%GPU" type="logicGroup"/>
        <node id="slice" displayName="%slice" type="multiDevice" color="#CDCDCD" textColor="#666666">
          <xsl:attribute name="count">%Total: <xsl:value-of select="$sCount"/></xsl:attribute>
        </node>
        <node id="dss" displayName="%dsS" type="multiDevice" color="white" textColor="#666666">
          <xsl:attribute name="count">%Total: <xsl:value-of select="$dssCount"/></xsl:attribute>
        </node>
        <node id="euArray" displayName="%euArray" type="multiDevice" color="#C7BFD1">
          <xsl:attribute name="count">%Total: <xsl:value-of select="$euCount"/></xsl:attribute>
          <rowSet>
            <queryRef displayName="%Active">/GPUEUActive</queryRef>
            <queryRef displayName="%Stalled">/GPUEUStalled</queryRef>
            <queryRef displayName="%Idle">/GPUEUIdle</queryRef>
            <queryRef displayName="%ThreadIssued">/GPUCSThreadIssuedCount</queryRef>
            <queryRef displayName="%ThreadOccupancy">/GPUEuThreadOccupancy</queryRef>
            <queryRef displayName="%GPUEuAvgIpcRateShort">/GPUEuAvgIpcRate</queryRef>
            <queryRef displayName="%GPUEuFpuActiveShort">/GPUFpuActive</queryRef>
            <queryRef displayName="%GPUEuEmActiveShort">/GPUEuEmActive</queryRef>
            <queryRef displayName="%GPUEuXMXActiveShort">/GPUEuSysActive</queryRef>
          </rowSet>
        </node>
        <node id="cpuCores" displayName="%CPUCores" type="multiDevice" color="#C7BFD1"/>
        <node id="cpu" displayName="%CPU" aligning="from" type="logicGroup" color="#EAEAEA">
        </node>
        <node id="sampler" displayName="%Sampler" color="#C3D1A5">
          <rowSet>
            <queryRef displayName="%Busy">/GPUSamplerBusy</queryRef>
            <queryRef displayName="%Bottleneck">/GPUSamplerBottleneck</queryRef>
          </rowSet>
        </node>
        <node id="l1" displayName="%L1" color="#f9c499"/>
        <node id="l2" displayName="%L2" color="#f9c499"/>
        <node id="l3" displayName="%L3" color="#f9c499">
          <rowSet>
            <queryRef displayName="%MissRatio">/GPUL3MissRatio</queryRef>
          </rowSet>
        </node>
        <node id="slm" displayName="%SLM" color="#E3A471"/>
        <node id="pcie" displayName="%PCIe" color="#CDCDCD"/>
        <node id="HBM" displayName="%HBM" color="#edcdcb"/>
        <node id="uncore" displayName="%Uncore" type="logicGroup"/>
        <node id="system" displayName="%System" type="logicGroup"/>
        <node id="dram" displayName="%DRAMDGR" color="#edcdcb"/>
        <node id="llc" displayName="%LLC" color="#f9c499">
          <rowSet>
            <queryRef displayName="%MissRate">/GPULlcMissRate</queryRef>
            <queryRef displayName="%MissRatio">/GPULlcMissRatio</queryRef>
          </rowSet>
        </node>
        <link id="euArray_slm">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUSharedLocalMemoryReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUSharedLocalMemoryReadB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUSLMReadAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUSharedLocalMemoryWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUSharedLocalMemoryWriteB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUSLMWriteAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
        <link id="sampler_l3">
          <label location="center">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef displayName="%Total">/GPUL3SamplerBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef displayName="%Total">/GPUL3SamplerThroughputB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef displayName="%Total">/GPUL3SamplerBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
        <link id="euArray_l3" displayName="%Buffers">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef displayName="%UntypedRead">/GPUUntypedMemoryReadBandwidthB</queryRef>
                  <queryRef displayName="%TypedRead">/GPUTypedMemoryReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef displayName="%UntypedRead">/GPUUntypedMemoryReadB</queryRef>
                  <queryRef displayName="%TypedRead">/GPUTypedMemoryReadB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef displayName="%UntypedRead">/GPUUntypedMemoryReadBDWAbsMaxRatio</queryRef>
                  <queryRef displayName="%TypedRead">/GPUTypedMemoryReadBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef displayName="%UntypedWrite">/GPUUntypedMemoryWriteBandwidthB</queryRef>
                  <queryRef displayName="%TypedWrite">/GPUTypedMemoryWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef displayName="%UntypedWrite">/GPUUntypedMemoryWriteB</queryRef>
                  <queryRef displayName="%TypedWrite">/GPUTypedMemoryWriteB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef displayName="%UntypedWrite">/GPUUntypedMemoryWriteBDWAbsMaxRatio</queryRef>
                  <queryRef displayName="%TypedWrite">/GPUTypedMemoryWriteBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="center" displayName="%Total">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef displayName="%Total">/GPUL3ShaderBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef displayName="%Total">/GPUL3ShaderThroughputB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef displayName="%Total">/GPUL3ShaderBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
        <link id="l3_HBM">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUMemoryReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUMemoryReadB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUMemoryReadBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUMemoryWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUMemoryWriteB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUMemoryWriteBDWAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
        <link id="llc_dram">
          <label location="from">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUAverageReadBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUDataReadB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUReadBandwidthAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
          <label location="to">
            <dataTransfer>
              <bandwidth>
                <rowSet>
                  <queryRef>/GPUAverageWriteBandwidthB</queryRef>
                </rowSet>
              </bandwidth>
              <size>
                <rowSet>
                  <queryRef>/GPUDataWrittenB</queryRef>
                </rowSet>
              </size>
              <ratio>
                <rowSet>
                  <queryRef>/GPUWriteBandwidthAbsMaxRatio</queryRef>
                </rowSet>
              </ratio>
            </dataTransfer>
          </label>
        </link>
      </display>
    </diagram>
  </xsl:template>
</xsl:stylesheet>
