<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown_big" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>/RetiredPipelineSlots_big</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="Light_OperationsGroup">
                                <queryInherit>/Light_Operations_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="Light_OperationsGroupExpanded">
                                        <derivedQuery id="FP_ArithGroup">
                                            <queryInherit>/FP_Arith_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="FP_ArithGroupExpanded">
                                                    <queryRef>/FP_x87_big</queryRef>
                                                    <queryRef>/FP_Scalar_big</queryRef>
                                                    <queryRef>/FP_Vector_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="Int_OperationsGroup">
                                            <queryInherit>/Int_Operations_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Int_OperationsGroupExpanded">
                                                    <queryRef>/Int_Vector_128b_big</queryRef>
                                                    <queryRef>/Int_Vector_256b_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/Memory_Operations_big</queryRef>
                                        <queryRef>/Fused_Instructions_big</queryRef>
                                        <queryRef>/Non_Fused_Branches_big</queryRef>
                                        <queryRef>/OTHER_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="Heavy_OperationsGroup">
                                <queryInherit>/Heavy_Operations_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="Heavy_OperationsGroupExpanded">
                                        <queryRef>/Few_Uops_Instructions_big</queryRef>
                                        <queryRef>/MicroSequencer_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>/FrontendBoundPipelineSlots_big</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="FELatencyGroup">
                                <queryInherit>/FELatency_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FELatencyGroupExpanded">
                                        <queryRef>/ICacheMisses_big</queryRef>
                                        <queryRef>/ITLBOverhead_big</queryRef>
                                        <derivedQuery id="BranchResteersGroup">
                                            <queryInherit>/BranchResteers_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="BranchResteersGroupExpanded">
                                                    <queryRef>/Unknown_Branches_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/MSSwitches_big</queryRef>
                                        <queryRef>/LCP_big</queryRef>
                                        <queryRef>/DSBtoMITESwitchCost_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="FEBandwidthGroup">
                                <queryInherit>/FEBandwidth_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FEBandwidthGroupExpanded">
                                        <queryRef>/FEBandwidthMITE_big</queryRef>
                                        <queryRef>/FEBandwidthDSB_big</queryRef>
                                        <queryRef>/FEBandwidthLSD_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>/CancelledPipelineSlots_big</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <derivedQuery id="BranchMispredictGroup">
                                <queryInherit>/BranchMispredict_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="BranchMispredictGroupExpanded">
                                        <queryRef>/Other_Mispredicts_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="MachineClearsGroup">
                                <queryInherit>/MachineClears_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MachineClearsGroupExpanded">
                                        <queryRef>/Other_Nukes_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>/BackendBound_big</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <derivedQuery id="MemBoundGroup">
                                <queryInherit>/MemBound_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemBoundGroupExpanded">
                                        <queryRef>/L1Bound_big</queryRef>
                                        <queryRef>/L2Bound_big</queryRef>
                                        <queryRef>/L3Bound_big</queryRef>
                                        <queryRef>/DRAMBound_big</queryRef>
                                        <queryRef>/StoresBound_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="CoreBoundGroup">
                                <queryInherit>/CoreBound_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="CoreBoundGroupExpanded">
                                        <queryRef>/DIVActive_big</queryRef>
                                        <queryRef>/Serializing_Operation_big</queryRef>
                                        <queryRef>/PortUtil_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Operations" id="Light_Operations_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Light_OperationsDescriptionAll</description>
                    <helpKeyword>configs.light_operations_light_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) if ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%Light_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Light_Operations_big") > 0.6 ) ) && ( ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="FP_Arith_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_x87_big") + query("/FP_Scalar_big") + query("/FP_Vector_big") ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Arith_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="FP_x87_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/RetiredPipelineSlots_big") * query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") / query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") ) ]]></valueEval>
                    <issueText>%FP_x87IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_x87_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FP_Arith_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="FP_Scalar_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Scalar_big") / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%FP_ScalarIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Scalar_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Vector_big") > 0.1) ) && ( ( ( query("/FP_Arith_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="FP_Vector_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Vector_big") / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%FP_VectorIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Vector_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar_big") > 0.1) ) && ( ( ( query("/FP_Arith_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Operations" id="Int_Operations_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%Int_OperationsDescriptionAll</description>
                    <helpKeyword>configs.int_operations_int_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Int_Vector_128b_big") + query("/Int_Vector_256b_big") ) ]]></valueEval>
                    <issueText>%Int_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Operations_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Vector_128b" id="Int_Vector_128b_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%Int_Vector_128bDescriptionAll</description>
                    <helpKeyword>configs.int_vector_128b_int_vector_128bdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%Int_Vector_128bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Vector_128b_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar_big") > 0.1) || ( queryOptional("/FP_Vector_big") > 0.1) ) && ( ( ( query("/Int_Operations_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Vector_256b" id="Int_Vector_256b_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%Int_Vector_256bDescriptionAll</description>
                    <helpKeyword>configs.int_vector_256b_int_vector_256bdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%Int_Vector_256bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Vector_256b_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar_big") > 0.1) || ( queryOptional("/FP_Vector_big") > 0.1) ) && ( ( ( query("/Int_Operations_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Operations" id="Memory_Operations_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Memory_OperationsDescriptionAll</description>
                    <helpKeyword>configs.memory_operations_memory_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Operations_big") * query("/PMUEventCount/PMUEventType[MEM_UOP_RETIRED.ANY]/PMUCoreType[P-Core]") / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%Memory_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Memory_Operations_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Fused_Instructions" id="Fused_Instructions_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Fused_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.fused_instructions_fused_instructionsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Operations_big") * query("/PMUEventCount/PMUEventType[INST_RETIRED.MACRO_FUSED]/PMUCoreType[P-Core]") / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%Fused_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Fused_Instructions_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Non_Fused_Branches" id="Non_Fused_Branches_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Non_Fused_BranchesDescriptionAll</description>
                    <helpKeyword>configs.non_fused_branches_non_fused_branchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Operations_big") * ( query("/PMUEventCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") - query("/PMUEventCount/PMUEventType[INST_RETIRED.BR_FUSED]/PMUCoreType[P-Core]") ) / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%Non_Fused_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Non_Fused_Branches_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.BR_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="OTHER_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Light_Operations_big") - query("/Light_Ops_Sum_big") ) if ( query("/Light_Operations_big") - query("/Light_Ops_Sum_big") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/OTHER_big") > 0.3 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.3 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.BR_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) if ( ( ( query("/Light_Operations_big") - query("/Light_Ops_Sum_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Heavy_Operations" id="Heavy_Operations_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Heavy_OperationsDescriptionAll</description>
                    <helpKeyword>configs.heavy_operations_heavy_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%Heavy_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Heavy_Operations_big") > 0.1 ) ) && ( ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Instructions" id="Few_Uops_Instructions_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Few_Uops_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.few_uops_instructions_few_uops_instructionsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Heavy_Operations_big") - query("/MicroSequencer_big") ) if ( query("/Heavy_Operations_big") - query("/MicroSequencer_big") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%Few_Uops_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Few_Uops_Instructions_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Heavy_Operations_big") > 0.1 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations_big") - query("/MicroSequencer_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="MicroSequencer_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[P-Core]") / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MicroSequencer_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches_big") > 0.05) || ( queryOptional("/MachineClears_big") > 0.1) || ( queryOptional("/L1Bound_big") > 0.1) || ( queryOptional("/MSSwitches_big") > 0.05) ) && ( ( query("/Heavy_Operations_big") > 0.1 ) && ( ( query("/RetiredPipelineSlots_big") > 0.7 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]/PMUCoreType[P-Core]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS_big") - query("/PMUEventCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="FELatency_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]/PMUCoreType[P-Core]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS_big") - query("/PMUEventCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") / query("/SLOTS_big") ) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FELatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ICACHE_DATA.STALLS]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ICacheMisses_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_DATA.STALLS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ICACHE_TAG.STALLS]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ITLBOverhead_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_TAG.STALLS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") + query("/Unknown_Branches_big") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchResteers_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Unknown_Branches" id="Unknown_Branches_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Unknown_BranchesDescriptionAll</description>
                    <helpKeyword>configs.unknown_branches_unknown_branchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Unknown_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Unknown_Branches_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/BranchResteers_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/FELatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UNKNOWN_BRANCH_CYCLES]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="MSSwitches_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MS_Switches_Cost_big") * query("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%MSSwitchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MSSwitches_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer_big") > 0.05) || ( queryOptional("/MachineClears_big") > 0.1) || ( queryOptional("/L1Bound_big") > 0.1) || ( queryOptional("/MicroSequencer_big") > 0.05) || ( queryOptional("/Serializing_Operation_big") > 0.1) ) && ( ( ( query("/FELatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="LCP_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DECODE.LCP]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%LCPIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LCP_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DSBtoMITESwitchCost_big") > 0.05) || ( queryOptional("/FEBandwidth_big") > 0.2) ) && ( ( ( query("/FELatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="DSBtoMITESwitchCost_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%DSBtoMITESwitchCostIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DSBtoMITESwitchCost_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/LCP_big") > 0.05) || ( queryOptional("/FEBandwidth_big") > 0.2) ) && ( ( ( query("/FELatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="FEBandwidth_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_big") - query("/FELatency_big") ) if ( query("/FrontendBoundPipelineSlots_big") - query("/FELatency_big") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidth_big") > 0.2 ) || ( queryOptional("/LCP_big") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost_big") > 0.05) ) && ( ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FETCH_LATENCY]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots_big") - query("/FELatency_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="FEBandwidthMITE_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthMITEDescriptionAll</description>
                    <helpKeyword>configs.febandwidthmite_febandwidthmitedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[IDQ.MITE_UOPS:eq1:cmask=8:inv=yes]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") + query("/PMUEventCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[P-Core]") / ( query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[P-Core]") + query("/PMUEventCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[P-Core]") ) * ( query("/PMUEventCount/PMUEventType[IDQ_BUBBLES.CYCLES_0_UOPS_DELIV.CORE]/PMUCoreType[P-Core]") - query("/PMUEventCount/PMUEventType[IDQ_BUBBLES.FETCH_LATENCY]/PMUCoreType[P-Core]") ) ) / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%FEBandwidthMITEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthMITE_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FEBandwidth_big") > 0.2 ) || ( queryOptional("/LCP_big") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost_big") > 0.05) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS:eq1:cmask=8:inv=yes]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[P-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[P-Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[IDQ_BUBBLES.CYCLES_0_UOPS_DELIV.CORE]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ_BUBBLES.FETCH_LATENCY]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDSB" id="FEBandwidthDSB_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDSBDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdsb_febandwidthdsbdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS:eq1:cmask=8:inv=yes]/PMUCoreType[P-Core]") + query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[P-Core]") / ( query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[P-Core]") + query("/PMUEventCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[P-Core]") ) * ( query("/PMUEventCount/PMUEventType[IDQ_BUBBLES.CYCLES_0_UOPS_DELIV.CORE]/PMUCoreType[P-Core]") - query("/PMUEventCount/PMUEventType[IDQ_BUBBLES.FETCH_LATENCY]/PMUCoreType[P-Core]") ) ) / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%FEBandwidthDSBIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthDSB_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FEBandwidth_big") > 0.2 ) || ( queryOptional("/LCP_big") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost_big") > 0.05) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS:eq1:cmask=8:inv=yes]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[P-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[P-Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[IDQ_BUBBLES.CYCLES_0_UOPS_DELIV.CORE]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ_BUBBLES.FETCH_LATENCY]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthLSD" id="FEBandwidthLSD_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthLSDDescriptionAll</description>
                    <helpKeyword>configs.febandwidthlsd_febandwidthlsddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LSD.UOPS:eq1:cmask=8:inv=yes]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%FEBandwidthLSDIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthLSD_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FEBandwidth_big") > 0.2 ) || ( queryOptional("/LCP_big") > 0.05) || ( queryOptional("/DSBtoMITESwitchCost_big") > 0.05) && ( query("/FrontendBoundPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LSD.UOPS:eq1:cmask=8:inv=yes]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 1 - ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") + query("/RetiredPipelineSlots_big") ) ) if ( 1 - ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") + query("/RetiredPipelineSlots_big") ) ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_big") > 0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") ) + query("/RetiredPipelineSlots_big") ) ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]/PMUCoreType[P-Core]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchMispredict_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/CancelledPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Mispredicts" id="Other_Mispredicts_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Other_MispredictsDescriptionAll</description>
                    <helpKeyword>configs.other_mispredicts_other_mispredictsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/BranchMispredict_big") * ( 1 - query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") / ( query("/PMUEventCount/PMUEventType[INT_MISC.CLEARS_COUNT]/PMUCoreType[P-Core]") - query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") ) ) ) if ( query("/BranchMispredict_big") * ( 1 - query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") / ( query("/PMUEventCount/PMUEventType[INT_MISC.CLEARS_COUNT]/PMUCoreType[P-Core]") - query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") ) ) ) > 0.0001 else 0.0001 ) ]]></valueEval>
                    <issueText>%Other_MispredictsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Other_Mispredicts_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/BranchMispredict_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/CancelledPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict_big") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]/PMUCoreType[P-Core]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="MachineClears_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_big") - query("/BranchMispredict_big") ) if ( query("/CancelledPipelineSlots_big") - query("/BranchMispredict_big") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MachineClears_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer_big") > 0.05) || ( queryOptional("/MSSwitches_big") > 0.05) || ( queryOptional("/L1Bound_big") > 0.1) ) && ( ( query("/CancelledPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") ) + query("/RetiredPipelineSlots_big") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots_big") - query("/BranchMispredict_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Nukes" id="Other_Nukes_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Other_NukesDescriptionAll</description>
                    <helpKeyword>configs.other_nukes_other_nukesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/MachineClears_big") * ( 1 - query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[P-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") ) ) if ( query("/MachineClears_big") * ( 1 - query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[P-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") ) ) > 0.0001 else 0.0001 ) ]]></valueEval>
                    <issueText>%Other_NukesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Other_Nukes_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MachineClears_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer_big") > 0.05) || ( queryOptional("/MSSwitches_big") > 0.05) || ( queryOptional("/L1Bound_big") > 0.1) && ( query("/CancelledPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") ) + query("/RetiredPipelineSlots_big") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots_big") - query("/BranchMispredict_big") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears_big") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[P-Core]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound_big") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]/PMUCoreType[P-Core]") / ( $muxGroupCount if $allowMultipleRuns else 1 ) ) / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEMORY_STALLS.L1]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer_big") > 0.05) || ( queryOptional("/MSSwitches_big") > 0.05) || ( queryOptional("/MachineClears_big") > 0.1) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_STALLS.L1]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEMORY_STALLS.L2]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L2Bound_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_STALLS.L2]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEMORY_STALLS.L3]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3Bound_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_STALLS.L3]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="DRAMBound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_Bound_Ratio_big") ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DRAMBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_STALLS.MEM]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/BackendBound_big") - query("/MemBound_big") ) if ( query("/BackendBound_big") - query("/MemBound_big") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound_big") - query("/MemBound_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="DIVActive_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ARITH.DIV_ACTIVE]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%DIVActiveIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DIVActive_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[BE_STALLS.SCOREBOARD]/PMUCoreType[P-Core]") + query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.C02]/PMUCoreType[P-Core]") ) / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Serializing_Operation_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches_big") > 0.05) ) && ( ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[BE_STALLS.SCOREBOARD]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.C02]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="PortUtil_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Cycles_big") / query("/DerivedClockticks_big") if ( query("/PMUEventCount/PMUEventType[ARITH.DIV_ACTIVE]/PMUCoreType[P-Core]") < ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[P-Core]") - query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]/PMUCoreType[P-Core]") ) ) else query("/Few_Uops_Executed_Threshold_big") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%PortUtilIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/PortUtil_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]/PMUCoreType[P-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]/PMUCoreType[P-Core]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[P-Core]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]/PMUCoreType[P-Core]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Cycles" id="Core_Bound_Cycles_big">
                    <description>%Core_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.core_bound_cycles_core_bound_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]/PMUCoreType[P-Core]") + query("/Few_Uops_Executed_Threshold_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]/PMUCoreType[P-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="Few_Uops_Executed_Threshold_big">
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") + query("/RetiredPipelineSlots_big") * query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Scalar" id="FP_Arith_Scalar_big">
                    <description>%FP_Arith_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_scalar_fp_arith_scalardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Vector" id="FP_Arith_Vector_big">
                    <description>%FP_Arith_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_vector_fp_arith_vectordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Ops_Sum" id="Light_Ops_Sum_big">
                    <description>%Light_Ops_SumDescriptionAll</description>
                    <helpKeyword>configs.light_ops_sum_light_ops_sumdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_big") + query("/Int_Operations_big") + query("/Memory_Operations_big") + query("/Fused_Instructions_big") + query("/Non_Fused_Branches_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.BR_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_Bound_Ratio" id="MEM_Bound_Ratio_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_ratio_mem_bound_ratiodescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEMORY_STALLS.MEM]/PMUCoreType[P-Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_STALLS.MEM]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MS_Switches_Cost" id="MS_Switches_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%MS_Switches_CostDescriptionAll</description>
                    <helpKeyword>configs.ms_switches_cost_ms_switches_costdescriptionall</helpKeyword>
                    <valueEval>3</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="Retired_Slots_big">
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/RetiredPipelineSlots_big") * query("/SLOTS_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS_big">
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DerivedIssueSlots_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.SLOTS:perf_metrics]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown_big" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorLight_OperationsGroup">
                                            <queryInherit>/locatorLight_Operations_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorLight_OperationsGroupExpanded">
                                                    <derivedQuery id="locatorFP_ArithGroup">
                                                        <queryInherit>/locatorFP_Arith_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorFP_ArithGroupExpanded">
                                                                <queryRef>/locatorFP_x87_big</queryRef>
                                                                <queryRef>/locatorFP_Scalar_big</queryRef>
                                                                <queryRef>/locatorFP_Vector_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorInt_OperationsGroup">
                                                        <queryInherit>/locatorInt_Operations_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorInt_OperationsGroupExpanded">
                                                                <queryRef>/locatorInt_Vector_128b_big</queryRef>
                                                                <queryRef>/locatorInt_Vector_256b_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorMemory_Operations_big</queryRef>
                                                    <queryRef>/locatorFused_Instructions_big</queryRef>
                                                    <queryRef>/locatorNon_Fused_Branches_big</queryRef>
                                                    <queryRef>/locatorOTHER_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorHeavy_OperationsGroup">
                                            <queryInherit>/locatorHeavy_Operations_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorHeavy_OperationsGroupExpanded">
                                                    <queryRef>/locatorFew_Uops_Instructions_big</queryRef>
                                                    <queryRef>/locatorMicroSequencer_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorFELatencyGroup">
                                            <queryInherit>/locatorFELatency_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFELatencyGroupExpanded">
                                                    <queryRef>/locatorICacheMisses_big</queryRef>
                                                    <queryRef>/locatorITLBOverhead_big</queryRef>
                                                    <derivedQuery id="locatorBranchResteersGroup">
                                                        <queryInherit>/locatorBranchResteers_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorBranchResteersGroupExpanded">
                                                                <queryRef>/locatorUnknown_Branches_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorMSSwitches_big</queryRef>
                                                    <queryRef>/locatorLCP_big</queryRef>
                                                    <queryRef>/locatorDSBtoMITESwitchCost_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorFEBandwidthGroup">
                                            <queryInherit>/locatorFEBandwidth_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFEBandwidthGroupExpanded">
                                                    <queryRef>/locatorFEBandwidthMITE_big</queryRef>
                                                    <queryRef>/locatorFEBandwidthDSB_big</queryRef>
                                                    <queryRef>/locatorFEBandwidthLSD_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorBranchMispredictGroup">
                                            <queryInherit>/locatorBranchMispredict_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorBranchMispredictGroupExpanded">
                                                    <queryRef>/locatorOther_Mispredicts_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorMachineClearsGroup">
                                            <queryInherit>/locatorMachineClears_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMachineClearsGroupExpanded">
                                                    <queryRef>/locatorOther_Nukes_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <derivedQuery id="locatorMemBoundGroup">
                                            <queryInherit>/locatorMemBound_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemBoundGroupExpanded">
                                                    <queryRef>/locatorL1Bound_big</queryRef>
                                                    <queryRef>/locatorL2Bound_big</queryRef>
                                                    <queryRef>/locatorL3Bound_big</queryRef>
                                                    <queryRef>/locatorDRAMBound_big</queryRef>
                                                    <queryRef>/locatorStoresBound_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorCoreBoundGroup">
                                            <queryInherit>/locatorCoreBound_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorCoreBoundGroupExpanded">
                                                    <queryRef>/locatorDIVActive_big</queryRef>
                                                    <queryRef>/locatorSerializing_Operation_big</queryRef>
                                                    <queryRef>/locatorPortUtil_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]", true)) * queryAll("/RetiredPipelineSlots_big", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") > 0.7 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Operations" id="locatorLight_Operations_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Light_OperationsDescriptionAll</description>
                    <helpKeyword>configs.light_operations_light_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.PREC_DIST]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INST_RETIRED.PREC_DIST]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[INST_RETIRED.PREC_DIST]/PMUCoreType[P-Core]", true)) * queryAll("/Light_Operations_big", true) ) ]]></valueEval>
                    <issueText>%Light_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLight_Operations") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="locatorFP_Arith_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Arith_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]", true) ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Arith") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="locatorFP_x87_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_x87_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]", true) ) ]]></valueEval>
                    <issueText>%FP_x87IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_x87") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="locatorFP_Scalar_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Scalar_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]", true) ) ]]></valueEval>
                    <issueText>%FP_ScalarIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Scalar") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="locatorFP_Vector_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Vector_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]", true) ) ]]></valueEval>
                    <issueText>%FP_VectorIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Vector") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Operations" id="locatorInt_Operations_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_OperationsDescriptionAll</description>
                    <helpKeyword>configs.int_operations_int_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Operations_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]", true) ) ]]></valueEval>
                    <issueText>%Int_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Operations") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Vector_128b" id="locatorInt_Vector_128b_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Vector_128bDescriptionAll</description>
                    <helpKeyword>configs.int_vector_128b_int_vector_128bdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Vector_128b_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]", true) ) ]]></valueEval>
                    <issueText>%Int_Vector_128bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Vector_128b") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Vector_256b" id="locatorInt_Vector_256b_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Vector_256bDescriptionAll</description>
                    <helpKeyword>configs.int_vector_256b_int_vector_256bdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Vector_256b_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]", true) ) ]]></valueEval>
                    <issueText>%Int_Vector_256bIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Vector_256b") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Operations" id="locatorMemory_Operations_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Memory_OperationsDescriptionAll</description>
                    <helpKeyword>configs.memory_operations_memory_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Memory_Operations_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%Memory_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemory_Operations") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Fused_Instructions" id="locatorFused_Instructions_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Fused_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.fused_instructions_fused_instructionsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Fused_Instructions_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%Fused_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFused_Instructions") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Non_Fused_Branches" id="locatorNon_Fused_Branches_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Non_Fused_BranchesDescriptionAll</description>
                    <helpKeyword>configs.non_fused_branches_non_fused_branchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.BR_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Non_Fused_Branches_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%Non_Fused_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorNon_Fused_Branches") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="locatorOTHER_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.BR_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) if ( ( ( query("/Light_Operations_big") - query("/Light_Ops_Sum_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/OTHER_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOTHER") > 0.3 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Heavy_Operations" id="locatorHeavy_Operations_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Heavy_OperationsDescriptionAll</description>
                    <helpKeyword>configs.heavy_operations_heavy_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Heavy_Operations_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%Heavy_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorHeavy_Operations") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Instructions" id="locatorFew_Uops_Instructions_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Few_Uops_InstructionsDescriptionAll</description>
                    <helpKeyword>configs.few_uops_instructions_few_uops_instructionsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/Heavy_Operations_big") - query("/MicroSequencer_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Few_Uops_Instructions_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%Few_Uops_InstructionsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFew_Uops_Instructions") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="locatorMicroSequencer_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[P-Core]", true)) * queryAll("/MicroSequencer_big", true) ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMicroSequencer") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]/PMUCoreType[P-Core]", true)) * queryAll("/FrontendBoundPipelineSlots_big", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="locatorFELatency_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]/PMUCoreType[P-Core]", true)) * queryAll("/FELatency_big", true) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFELatency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]/PMUCoreType[P-Core]", true)) * queryAll("/ICacheMisses_big", true) ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorICacheMisses") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]/PMUCoreType[P-Core]", true)) * queryAll("/ITLBOverhead_big", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]", true)) * queryAll("/BranchResteers_big", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Unknown_Branches" id="locatorUnknown_Branches_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Unknown_BranchesDescriptionAll</description>
                    <helpKeyword>configs.unknown_branches_unknown_branchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.UNKNOWN_BRANCH]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.UNKNOWN_BRANCH]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.UNKNOWN_BRANCH]/PMUCoreType[P-Core]", true)) * queryAll("/Unknown_Branches_big", true) ) ]]></valueEval>
                    <issueText>%Unknown_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorUnknown_Branches") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="locatorMSSwitches_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[P-Core]", true)) * queryAll("/MSSwitches_big", true) ) ]]></valueEval>
                    <issueText>%MSSwitchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMSSwitches") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="locatorLCP_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DECODE.LCP]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/LCP_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%LCPIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLCP") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="locatorDSBtoMITESwitchCost_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[P-Core]", true)) * queryAll("/DSBtoMITESwitchCost_big", true) ) ]]></valueEval>
                    <issueText>%DSBtoMITESwitchCostIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDSBtoMITESwitchCost") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="locatorFEBandwidth_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]/PMUCoreType[P-Core]", true)) * queryAll("/FEBandwidth_big", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidth") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="locatorFEBandwidthMITE_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthMITEDescriptionAll</description>
                    <helpKeyword>configs.febandwidthmite_febandwidthmitedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.ANY_DSB_MISS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.ANY_DSB_MISS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.ANY_DSB_MISS]/PMUCoreType[P-Core]", true)) * queryAll("/FEBandwidthMITE_big", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthMITEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthMITE") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDSB" id="locatorFEBandwidthDSB_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDSBDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdsb_febandwidthdsbdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS:eq1:cmask=8:inv=yes]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[P-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[P-Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[IDQ_BUBBLES.CYCLES_0_UOPS_DELIV.CORE]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ_BUBBLES.FETCH_LATENCY]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthDSB_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthDSBIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthDSB") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthLSD" id="locatorFEBandwidthLSD_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthLSDDescriptionAll</description>
                    <helpKeyword>configs.febandwidthlsd_febandwidthlsddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LSD.UOPS:eq1:cmask=8:inv=yes]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthLSD_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthLSDIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthLSD") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") ) + query("/RetiredPipelineSlots_big") ) ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]/PMUCoreType[P-Core]", true)) * queryAll("/BranchMispredict_big", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Mispredicts" id="locatorOther_Mispredicts_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Other_MispredictsDescriptionAll</description>
                    <helpKeyword>configs.other_mispredicts_other_mispredictsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) ) if ( ( ( query("/BranchMispredict_big") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") ) / ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEARS_COUNT]/PMUCoreType[P-Core]") ) - ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") ) ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Other_Mispredicts_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%Other_MispredictsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOther_Mispredicts") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="locatorMachineClears_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]", true)) * queryAll("/MachineClears_big", true) ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Other_Nukes" id="locatorOther_Nukes_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Other_NukesDescriptionAll</description>
                    <helpKeyword>configs.other_nukes_other_nukesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.FRONTEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") ) + query("/RetiredPipelineSlots_big") ) ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BRANCH_MISPREDICTS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots_big") - query("/BranchMispredict_big") ) > 0 ) ) else ( 0 ) ) || (  ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) if ( ( ( query("/MachineClears_big") * ( 1 - ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[P-Core]") ) / ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[P-Core]") ) ) ) ) > 0.0001 ) ) else ( 0.0001 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Other_Nukes_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%Other_NukesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOther_Nukes") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[P-Core]", true)) * queryAll("/BackendBound_big", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]/PMUCoreType[P-Core]", true)) * queryAll("/MemBound_big", true) ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[P-Core]", true)) * queryAll("/L1Bound_big", true) ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1Bound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_STALLS.L2]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/L2Bound_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Bound") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[P-Core]", true)) * queryAll("/L3Bound_big", true) ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="locatorDRAMBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_STALLS.MEM]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/DRAMBound_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDRAMBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[P-Core]", true)) * queryAll("/StoresBound_big", true) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.BACKEND_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.MEMORY_BOUND]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound_big") - query("/MemBound_big") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CoreBound_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="locatorDIVActive_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[P-Core]", true)) * queryAll("/DIVActive_big", true) ) ]]></valueEval>
                    <issueText>%DIVActiveIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDIVActive") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]/PMUCoreType[P-Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]/PMUCoreType[P-Core]") / queryAll("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]/PMUCoreType[P-Core]", true)) * queryAll("/Serializing_Operation_big", true) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSerializing_Operation") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="locatorPortUtil_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]/PMUCoreType[P-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIV_ACTIVE]/PMUCoreType[P-Core]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[P-Core]") ) - ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_LOADS]/PMUCoreType[P-Core]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PortUtil_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%PortUtilIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPortUtil") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Cycles" id="locatorCore_Bound_Cycles_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Core_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.core_bound_cycles_core_bound_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.EXE_BOUND_0_PORTS]/PMUCoreType[P-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Cycles_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="locatorFew_Uops_Executed_Threshold_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_3_PORTS_UTIL]/PMUCoreType[P-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Few_Uops_Executed_Threshold_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Scalar" id="locatorFP_Arith_Scalar_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Arith_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_scalar_fp_arith_scalardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Scalar_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Vector" id="locatorFP_Arith_Vector_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Arith_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_vector_fp_arith_vectordescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Vector_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Ops_Sum" id="locatorLight_Ops_Sum_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Light_Ops_SumDescriptionAll</description>
                    <helpKeyword>configs.light_ops_sum_light_ops_sumdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[P-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.VECTOR]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.128BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_VEC_RETIRED.256BIT]/PMUCoreType[P-Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_UOP_RETIRED.ANY]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.MACRO_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.HEAVY_OPERATIONS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") ) > 0 ) ) else ( 0 ) ) || ( ( query("/PMUSampleCount/PMUEventType[BR_INST_RETIRED.ALL_BRANCHES]/PMUCoreType[P-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.BR_FUSED]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Light_Ops_Sum_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_Bound_Ratio" id="locatorMEM_Bound_Ratio_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEM_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_ratio_mem_bound_ratiodescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEMORY_STALLS.MEM]/PMUCoreType[P-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[P-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_Bound_Ratio_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="locatorRetired_Slots_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[PERF_METRICS.RETIRING]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || SLOTS ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Retired_Slots_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="locatorSLOTS_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.SLOTS:perf_metrics]/PMUCoreType[P-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SLOTS_big") ) ]]></valueEval>
                </derivedQuery>
            </locatorqueryLibrary>
        </bag>
    </xsl:template>
    <xsl:variable name="isHTOn" select="exsl:ctx('isHTEnabled', 0) or (exsl:ctx('logicalCPUCount', 1) &gt; exsl:ctx('physicalCoreCount', 1))" />
    <xsl:variable name="is3DXOn" select="exsl:ctx('is3DXPPresent', 0) and not(exsl:ctx('is3DXP2LMMode', 0))" />
</xsl:stylesheet>
