/*******************************************************************************
* Copyright (C) 2022 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

//@HEADER
// ***************************************************
//
// HPCG: High Performance Conjugate Gradient Benchmark
//
// Contact:
// Michael A. Heroux ( maherou@sandia.gov)
// Jack Dongarra     (dongarra@eecs.utk.edu)
// Piotr Luszczek    (luszczek@eecs.utk.edu)
//
// ***************************************************
//@HEADER

#ifndef PERMUTEGRAPH_HPP
#define PERMUTEGRAPH_HPP

#include "mytimer.hpp"
#include "UsmUtil.hpp"

sycl::event PermuteGraph(sycl::queue &queue, const int rank,
                         local_int_t nx, local_int_t ny, local_int_t nz,
                         const local_int_t nrow, char *nonzerosInRow,
                         local_int_t **mtxIndL, double **matrixValues,
                         local_int_t *perm, local_int_t *invperm,
                         local_int_t &nColors, local_int_t *xcolors_dev,
                         const std::vector<sycl::event> dependencies = {});

#endif  // PERMUTEGRAPH_HPP
