#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain source snippets for entities in the bottomup
# table. Source is also available for entries in the topdown tree.
#
# Please, note that 'begin' and 'end' are _approximate_, based on debug info available.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.SURVEY)

# Iterate the entries in the bottmup table and print the source snippets.
for entry in data.bottomup:

    # In this case, source code is not present for the current entry.
    if not entry.source.content:

        print("No source found for {}".format(entry["function_call_sites_and_loops"]))

    # Otherwise, it's present and should be accessed then printed.
    else:

        print("Source for {}".format(entry["function_call_sites_and_loops"]))
        for line in entry.source.content[entry.source.begin : entry.source.end]:
            print(line)

    print("")
