<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009-2025 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="msxsl"
                xmlns:exsl="http://exslt.org/common"
                exsl:keep_exsl_namespace=""
                syntax="norules"
                xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
                xmlns:int="http://www.w3.org/2001/XMLSchema#int"
                xmlns:double="http://www.w3.org/2001/XMLSchema#double"
                xmlns:str="http://exslt.org/strings">
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="type"/>
  <xsl:template match="/">
    <knobs>
      <xsl:if test="$type = 'survey' or $type = 'tripcounts'">
        <enumKnob id="modules_switch" displayName="knob.modules_switch.name" cliName="module-filter-mode">
          <description>knob.modules_switch.description</description>
          <values>
            <value cliName="include">knob.modules_switch.include</value>
            <value cliName="exclude">knob.modules_switch.exclude</value>
            <defaultValue>knob.modules_switch.exclude</defaultValue>
          </values>
          <knobProperty name="style">radio_buttons</knobProperty>
          <boolean:knobProperty name="inheritable">true</boolean:knobProperty>
        </enumKnob>
        <listKnob id="modules" displayName="" cliName="module-filter">
          <description>knob.exclude_modules.description</description>
          <boolean:knobProperty name="inheritable">true</boolean:knobProperty>
        </listKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey' or $type = 'tripcounts'">
        <listKnob id="kernel_filter" displayName="knob.kernel_filter.name" cliName="gpu-kernel-of-interest" boolean:visible="true">
          <defaultValue>*</defaultValue>
          <description>knob.kernel_filter.description</description>
          <boolean:knobProperty name="inheritable">true</boolean:knobProperty>
        </listKnob>
        <enumKnob id="kernel_matching_mode" displayName="knob.kernel_matching_mode.name" cliName="gpu-kernel-matching-mode" boolean:visible="true">
          <description>knob.kernel_matching_mode.description</description>
          <values>
            <value cliName="strict" displayName="knob.kernel_matching_mode.strict">strict</value>
            <value cliName="relaxed" displayName="knob.kernel_matching_mode.relaxed">relaxed</value>
            <defaultValue>strict</defaultValue>
          </values>
          <boolean:knobProperty name="inheritable">true</boolean:knobProperty>
        </enumKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey' or $type = 'suitability' or $type = 'refinement'">
        <enumKnob id="mrte_mode" displayName="knob.mrte_mode.name" cliName="mrte-mode">
          <xsl:if test="exsl:ctx('hostOS') != 'Windows' and $type = 'refinement'">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <description>knob.mrte_mode.description</description>
          <values>
            <value displayName="knob.mrte_mode.auto" cliName="auto">auto</value>
            <value displayName="knob.mrte_mode.native" cliName="native">native</value>
            <value displayName="knob.mrte_mode.mixed" cliName="mixed">mixed</value>
            <value displayName="knob.mrte_mode.managed" cliName="managed">managed</value>
            <defaultValue>auto</defaultValue>
          </values>
          <boolean:knobProperty name="inheritable">true</boolean:knobProperty>
          <knobProperty name="style">radioButton</knobProperty>
        </enumKnob>
      </xsl:if>
      <stringKnob id="process_for_analysis" displayName="knob.process_for_analysis.name" cliName="executable-of-interest">
        <description>knob.process_for_analysis.description</description>
        <value></value>
        <boolean:knobProperty name="inheritable">true</boolean:knobProperty>
      </stringKnob>
      <xsl:if test="$type = 'tripcounts'">
        <booleanKnob id="trip_counts" displayName="knob.trip_counts.name" cliName="trip-counts">
          <description>knob.trip_counts.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
        <booleanKnob id="flops_and_masks" displayName="knob.flops_and_masks.name" cliName="flop">
          <description>knob.flops_and_masks.description</description>
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
        <booleanKnob id="stacks" displayName="knob.stacks.name" cliName="stacks">
          <description>knob.stacks.description</description>
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
        <booleanKnob id="enable_cache_simulation" displayName="knob.enable_cache_simulation_trc.name" cliName="enable-cache-simulation" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <description>knob.enable_cache_simulation_trc.description</description>
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
        <enumKnob id="cache_simulation" displayName="knob.cache_simulation.name" cliName="cache-simulation" boolean:visible="false">
          <xsl:choose>
            <xsl:when test="(exsl:ctx('CLIENT_ID') = 'CLI')">
              <xsl:attribute name="boolean:visible">true</xsl:attribute>
              <description>knob.cache_simulation_cli.description</description>
            </xsl:when>
            <xsl:otherwise>
              <description>knob.cache_simulation_gui.description</description>
            </xsl:otherwise>
          </xsl:choose>
          <values>
            <value cliName="off" displayName="knob.cache_simulation.off">off</value>
            <value cliName="single" displayName="knob.cache_simulation.single">single</value>
            <value cliName="multi" displayName="knob.cache_simulation.multi">multi</value>
            <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
              <value cliName="grf" displayName="knob.cache_simulation.grf">grf</value>
            </xsl:if>
            <defaultValue>off</defaultValue>
          </values>
        </enumKnob>
        <enumKnob id="cachesim_sampling_factor" displayName="knob.cachesim_sampling_factor.name" cliName="cachesim-sampling-factor" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <knobProperty name="active_state">enable_cache_simulation=true</knobProperty>
          <description>knob.cachesim_sampling_factor.description</description>
          <values>
            <value>10</value>
            <value>20</value>
            <value>30</value>
            <value>40</value>
            <value>50</value>
            <value>60</value>
            <value>70</value>
            <value>80</value>
            <value>90</value>
            <value>100</value>
            <defaultValue>10</defaultValue>
          </values>
        </enumKnob>
        <stringKnob id="cache_config" displayName="knob.cache_config.name" cliName="cache-config" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <description>knob.cache_config.description</description>
          <defaultValue></defaultValue>
        </stringKnob>
        <stringKnob id="config" displayName="knob.config_trc.name" cliName="config" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <description>knob.config_trc.description</description>
          <defaultValue></defaultValue>
        </stringKnob>
        <stringKnob id="target_device" displayName="knob.target_device.name" cliName="target-device">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <description>knob.target_device.description</description>
          <defaultValue></defaultValue>
        </stringKnob>
        <listKnob id="custom_config" displayName="knob.custom_config.name" cliName="custom-config">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <description>knob.custom_config.description</description>
          <defaultValue></defaultValue>
        </listKnob>
      </xsl:if>
      <xsl:if test="$type = 'refinement'">
        <enumKnob id="suppressions" cliName="suppressions" displayName="knob.suppressions.name">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <description>knob.suppressions.description</description>
          <values>
            <value displayName="knob.suppressions.none">none</value>
            <value displayName="knob.suppressions.delete">delete</value>
            <defaultValue>none</defaultValue>
          </values>
          <knobProperty name="style">radio_buttons</knobProperty>
        </enumKnob>
        <intKnob id="loop_call_count_limit" displayName="knob.loop_call_count_limit.name" cliName="loop-call-count-limit">
          <description>knob.loop_call_count_limit.description</description>
          <int:min>0</int:min>
          <int:max>10000000</int:max>
          <int:defaultValue>0</int:defaultValue>
        </intKnob>
        <stringKnob id="select" cliName="select" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <value></value>
        </stringKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey' or $type = 'suitability'">
        <intKnob id="interval" displayName="knob.sampling_interval.name" cliName="interval">
          <description>knob.sampling_interval.description</description>
          <int:min>1</int:min>
          <int:max>1000</int:max>
          <int:defaultValue>10</int:defaultValue>
        </intKnob>
        <intKnob id="dataLimit" displayName="knob.data_limit.name" cliName="data-limit">
          <description>knob.data_limit.description</description>
          <int:min>0</int:min>
          <int:max>1024000</int:max>
          <int:defaultValue>500</int:defaultValue>
        </intKnob>
        <stringKnob id="type_opt" boolean:visible="false">
          <defaultValue>
            <xsl:choose>
              <xsl:when test="$type = 'suitability'">projection:stack</xsl:when>
              <xsl:when test="$type = 'survey'">cpu:stack</xsl:when>
              <xsl:otherwise></xsl:otherwise>
            </xsl:choose>
          </defaultValue>
        </stringKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey'">
        <enumKnob id="stackwalk" displayName="knob.stack_walk.name" cliName="stackwalk-mode">
          <description>knob.stack_walk.description</description>
          <values>
            <value displayName="knob.stack_walk.online">online</value>
            <value displayName="knob.stack_walk.offline">offline</value>
            <defaultValue>offline</defaultValue>
          </values>
        </enumKnob>
        <intKnob id="stackUnwindLimit" displayName="knob.stack_unwind_limit.name" cliName="stack-unwind-limit">
          <knobProperty name="active_state">stackwalk=offline</knobProperty>
          <description>knob.stack_unwind_limit.description</description>
          <int:min>0</int:min>
          <int:defaultValue>8388608</int:defaultValue>
        </intKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey' or $type = 'tripcounts'">
        <enumKnob id="profile_python" displayName="knob.profile_python.name" cliName="profile-python">
          <description>knob.profile_python.description</description>
          <values>
            <value cliName="off" displayName="knob.profile_python.off">off</value>
            <value cliName="stacks" displayName="knob.profile_python.stacks">stacks</value>
            <value cliName="full" displayName="knob.profile_python.full">full</value>
            <defaultValue>off</defaultValue>
          </values>
        </enumKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey' or $type = 'tripcounts'">
        <booleanKnob id="stackStitching" displayName="knob.stack_stitching.name" cliName="stack-stitching">
          <xsl:if test="$type = 'tripcounts' and exsl:ctx('CLIENT_ID') != 'CLI'">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <description>knob.stack_stitching.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey'">
        <booleanKnob id="mklUserMode" displayName="knob.mkl_user_mode.name" cliName="mkl-user-mode">
          <description>knob.mkl_user_mode.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="$type = 'tripcounts'">
        <booleanKnob id="profile_jit" displayName="knob.profile_jit.name" cliName="profile-jit">
          <description>knob.profile_jit.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
        <booleanKnob id="profile_stripped_binaries" displayName="knob.profile_stripped_binaries.name" cliName="profile-stripped-binaries">
          <description>knob.profile_stripped_binaries.description</description>
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey'">
        <booleanKnob id="support_multi_isa_binaries" displayName="knob.support_multi_isa_binaries.name" cliName="support-multi-isa-binaries">
          <description>knob.support_multi_isa_binaries.description</description>
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
        <booleanKnob id="spillAnalysis" displayName="knob.spill_analysis.name" cliName="spill-analysis">
          <description>knob.spill_analysis.description</description>
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
        <booleanKnob id="static_instruction_mix" displayName="knob.static_instruction_mix.name" cliName="static-instruction-mix">
          <description>knob.static_instruction_mix.description</description>
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey' or $type = 'tripcounts'">
        <booleanKnob id="auto_finalize" cliName="auto-finalize" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey'">
        <listKnob id="follow_child_strategy" displayName="knob.follow_child_strategy.name" cliName="strategy" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <description>knob.follow_child_strategy.description</description>
        </listKnob>
      </xsl:if>
      <xsl:if test="$type = 'tripcounts' or $type = 'refinement'">
        <stringKnob id="loops" cliName="loops" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <value></value>
        </stringKnob>
        <stringKnob id="mark-up-list" cliName="mark-up-list" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <value></value>
        </stringKnob>
      </xsl:if>
      <xsl:if test="$type = 'tripcounts'">
        <stringKnob id="cs_file" cliName="cs-file" boolean:visible="false" />
        <stringKnob id="kernel_instances_file" cliName="kernel-instances-file" boolean:visible="false" />
        <booleanKnob id="benchmarks-sync" displayName="knob.benchmarks-sync.name" cliName="benchmarks-sync" boolean:visible="false">
          <xsl:if test="(exsl:ctx('CLIENT_ID') = 'CLI')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <description>knob.benchmarks_sync.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="$type = 'refinement'">
        <intKnob id="instance_of_interest" displayName="knob.instance_of_interest.name" cliName="instance-of-interest">
          <description>knob.instance_of_interest.description</description>
          <int:min>0</int:min>
          <int:defaultValue>0</int:defaultValue>
        </intKnob>
      </xsl:if>
      <xsl:if test="$type = 'suitability'">
        <booleanKnob id="cpu_profiling" displayName="knob.cpu_profiling.name" cliName="profile-cpu" boolean:visible="false">
          <description>knob.cpu_profiling.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey' or $type = 'tripcounts'">
        <booleanKnob id="show_report" cliName="show-report" boolean:visible="false">
          <xsl:if test="exsl:ctx('CLIENT_ID') = 'CLI'">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <description>knob.show_report.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
        <booleanKnob id="cpu_profiling" displayName="knob.cpu_profiling.name" cliName="profile-cpu" boolean:visible="false">
          <xsl:if test="exsl:ctx('CLIENT_ID') = 'CLI'">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <description>knob.cpu_profiling.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
        <booleanKnob id="gpu_profiling" displayName="knob.gpu_profiling.name" cliName="profile-gpu" boolean:visible="false">
          <xsl:if test="exsl:ctx('CLIENT_ID') = 'CLI'">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:if>
          <description>knob.gpu_profiling.description</description>
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
        <xsl:if test="$type = 'survey' or $type = 'tripcounts'">
          <listKnob id="cliTargetGPU" displayName="knob.cli_target_gpu.name" cliName="target-gpu" boolean:visible="false">
            <xsl:if test="exsl:ctx('CLIENT_ID') = 'CLI'">
              <xsl:attribute name="boolean:visible">true</xsl:attribute>
            </xsl:if>
            <defaultValue></defaultValue>
            <description>knob.cli_target_gpu.description</description>
          </listKnob>
        </xsl:if>
        <enumKnob id="targetGPU" displayName="knob.gui_target_gpu.name" boolean:visible="false">
          <xsl:variable name="defaultGPUBDF" select="exsl:ctx('preferedGpuAdapter', '')"/>
          <xsl:choose>
            <xsl:when test="count(str:split(exsl:ctx('gpuAdapterNameList',''), ';')) = 0">
              <values>
                <value displayName="knob.gui_target_gpu.none">none</value>
                <defaultValue>none</defaultValue>
              </values>
            </xsl:when>
            <xsl:otherwise>
              <xsl:choose>
                <xsl:when test="count(str:split(exsl:ctx('gpuAdapterNameList',''), ';')) = 1">
                  <description>knob.gui_target_gpu_single.description</description>
                </xsl:when>
                <xsl:otherwise>
                  <description>knob.gui_target_gpu_multi.description</description>
                </xsl:otherwise>
              </xsl:choose>
              <values>
                <xsl:variable name="allTargetGPUBDF">
                  <xsl:for-each select="str:split(exsl:ctx('gpuAdapterNameList', ''), ';')">
                    <value><xsl:value-of select="string(str:split(., '|')[1])"/><xsl:if test="not(position()=last())">,</xsl:if></value>
                  </xsl:for-each>
                </xsl:variable>
                <xsl:for-each select="str:split(exsl:ctx('gpuAdapterNameList', ''), ';')">
                  <xsl:variable name="targetGPUInfo" select="str:split(., '|')"/>
                  <xsl:variable name="targetGPUBDF" select="string($targetGPUInfo[1])"/>
                  <xsl:variable name="targetGPUName" select="string($targetGPUInfo[2])"/>
                  <value>
                    <xsl:attribute name="displayName">
                      <xsl:value-of select="concat($targetGPUBDF, ' : ', $targetGPUName)"/>
                    </xsl:attribute>
                    <xsl:value-of select="$targetGPUBDF"/>
                  </value>
                  <xsl:if test="$targetGPUBDF = $defaultGPUBDF and count(str:split($allTargetGPUBDF, ','))=1">
                    <defaultValue>
                      <xsl:attribute name="displayName">
                        <xsl:value-of select="concat($defaultGPUBDF, ' : ', $targetGPUName)"/>
                      </xsl:attribute>
                      <xsl:value-of select="$defaultGPUBDF"/>
                    </defaultValue>
                  </xsl:if>
                </xsl:for-each>
                <xsl:if test="count(str:split($allTargetGPUBDF, ',')) > 1">
                  <value displayName="knob.gui_target_gpu.all_value">all</value>
                  <defaultValue displayName="knob.gui_target_gpu.all_value">all</defaultValue>
                </xsl:if>
              </values>
            </xsl:otherwise>
          </xsl:choose>
        </enumKnob>
        <booleanKnob id="gpu_conditional_metrics" boolean:visible="false">
          <boolean:defaultValue>false</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey'">
        <booleanKnob id="openclSourceAsm" boolean:visible="false">
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
        <doubleKnob id="gpuSamplingInterval" displayName="knob.gpu_sampling_interval" cliName="gpu-sampling-interval" boolean:visible="true">
          <xsl:if test="exsl:ctx('CLIENT_ID') != 'CLI'">
            <xsl:attribute name="displayName">knob.gpu_sampling_interval.name</xsl:attribute>
          </xsl:if>
          <description>knob.gpu_sampling_interval.description</description>
          <double:min>0.1</double:min>
          <double:max>10</double:max>
          <double:defaultValue>1</double:defaultValue>
        </doubleKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey'">
        <enumKnob id="keepCaches" displayName="knob.keep_caches.name">
          <xsl:if test="exsl:ctx('CLIENT_ID') = 'CLI'">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <description>knob.keep_caches.description</description>
          <values>
            <value displayName="knob.keep_caches.keep" cliName="keep">keep</value>
            <value displayName="knob.keep_caches.clear" cliName="clear">clear</value>
            <defaultValue>clear</defaultValue>
          </values>
        </enumKnob>
      </xsl:if>
      <xsl:if test="$type = 'tripcounts'">
        <booleanKnob id="stl_profiling" boolean:visible="false">
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
      <xsl:if test="exsl:is_experimental('memory_filtering')">
        <xsl:if test="$type = 'refinement'">
          <booleanKnob id="accelerator_memory_filtering" displayName="knob.accelerator_memory_filtering.name" cliName="accelerator-memory-analysis">
            <description>knob.accelerator_memory_filtering.description</description>
            <boolean:defaultValue>false</boolean:defaultValue>
          </booleanKnob>
          <enumKnob id="accelerator_memory_analysis_mode" displayName="knob.accelerator_memory_analysis_mode.name" cliName="accelerator-memory-analysis-mode">
            <knobProperty name="active_state">accelerator_memory_filtering=true</knobProperty>
            <description>knob.accelerator_memory_analysis_mode.description</description>
            <values>
              <value cliName="lite">knob.accelerator_memory_analysis_mode.lite</value>
              <value cliName="full">knob.accelerator_memory_analysis_mode.full</value>
              <defaultValue>knob.accelerator_memory_analysis_mode.full</defaultValue>
            </values>
            <knobProperty name="style">radio_buttons</knobProperty>
          </enumKnob>
          <intKnob id="accelerator_memory_capacity" displayName="knob.accelerator_memory_capacity.name" cliName="accelerator-memory-capacity">
            <knobProperty name="active_state">accelerator_memory_filtering=true</knobProperty>
            <description>knob.accelerator_memory_capacity.description</description>
            <int:min>1</int:min>
            <int:max>1000000</int:max>
            <int:defaultValue>160</int:defaultValue>
          </intKnob>
        </xsl:if>
      </xsl:if>
      <xsl:if test="$type = 'tripcounts'">
        <booleanKnob id="data_transfer_analysis" displayName="knob.data_transfer_analysis.name" cliName="enable-data-transfer-analysis">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <boolean:defaultValue>false</boolean:defaultValue>
          <description>knob.data_transfer_analysis.description</description>
        </booleanKnob>
        <booleanKnob id="track_memory_objects" displayName="knob.track_memory_objects.name" cliName="track-memory-objects">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <boolean:defaultValue>false</boolean:defaultValue>
          <description>knob.track_memory_objects.description</description>
        </booleanKnob>
        <booleanKnob id="track_stack_accesses" displayName="knob.track_stack_accesses.name" cliName="track-stack-accesses">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <boolean:defaultValue>false</boolean:defaultValue>
          <knobProperty name="active_state">data_transfer_analysis=true</knobProperty>
          <description>knob.track_stack_accesses.description</description>
        </booleanKnob>
        <booleanKnob id="data_reuse_analysis" displayName="knob.data_reuse_analysis.name" cliName="data-reuse-analysis">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <boolean:defaultValue>false</boolean:defaultValue>
          <knobProperty name="active_state">data_transfer_analysis=true</knobProperty>
          <description>knob.data_reuse_analysis.description</description>
        </booleanKnob>
        <booleanKnob id="count_memory_objects_accesses" displayName="knob.count_memory_objects_accesses.name" cliName="count-memory-objects-accesses">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <boolean:defaultValue>false</boolean:defaultValue>
          <knobProperty name="active_state">data_reuse_analysis=true</knobProperty>
          <description>knob.count_memory_objects_accesses.description</description>
        </booleanKnob>
        <intKnob id="stack_access_granularity" displayName="knob.stack_access_granularity.name" cliName="stack-access-granularity">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <knobProperty name="active_state">data_transfer_analysis=true</knobProperty>
          <description>knob.stack_access_granularity.description</description>
          <defaultValue>1048576</defaultValue>
        </intKnob>
        <enumKnob id="page_size" displayName="knob.page_size.name" cliName="data-transfer-page-size">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <knobProperty name="active_state">data_transfer_analysis=true</knobProperty>
          <description>knob.page_size.description</description>
          <values>
            <value cliName="4">4</value>
            <value cliName="8">8</value>
            <value cliName="16">16</value>
            <value cliName="32">32</value>
            <value cliName="64">64</value>
            <value cliName="128">128</value>
            <value cliName="256">256</value>
            <value cliName="512">512</value>
            <value cliName="1024">1024</value>
            <value cliName="2048">2048</value>
            <value cliName="4096">4096</value>
            <value cliName="8192">8192</value>
            <defaultValue>4096</defaultValue>
          </values>
        </enumKnob>
        <enumKnob id="data_transfer" displayName="knob.data_transfer.name" cliName="data-transfer">
          <description>knob.data_transfer.description</description>
          <values>
            <value cliName="off" displayName="knob.data_transfer.off">off</value>
            <value cliName="light" displayName="knob.data_transfer.light">light</value>
            <value cliName="medium" displayName="knob.data_transfer.medium">medium</value>
            <value cliName="full" displayName="knob.data_transfer.full">full</value>
            <defaultValue>off</defaultValue>
          </values>
        </enumKnob>
      </xsl:if>
      <xsl:if test="$type = 'survey'">
        <booleanKnob id="profile_intel_perf_libs" displayName="knob.profile_intel_perf_libs.name" cliName="profile-intel-perf-libs">
          <xsl:if test="(exsl:ctx('CLIENT_ID') != 'CLI')">
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:if>
          <description>knob.profile_intel_perf_libs.description</description>
          <boolean:defaultValue>true</boolean:defaultValue>
        </booleanKnob>
      </xsl:if>
    </knobs>
  </xsl:template>
</xsl:stylesheet>
