import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { uniqueId } from 'lodash';
import { useCallback } from 'react';
import { toOption } from '@grafana/data';
import { Select, RadioButtonGroup, Input } from '@grafana/ui';
import '../types.js';
import { setPropertyField } from '../utils/sql.utils.js';
import { Space } from '../Space.js';
import { EditorField } from '../EditorField.js';
import { InputGroup } from '../InputGroup.js';

const sortOrderOptions = [
  { description: "Sort by ascending", value: "ASC", icon: "sort-amount-up" },
  { description: "Sort by descending", value: "DESC", icon: "sort-amount-down" }
];
function OrderByRow({ sql, onSqlChange, columns, showOffset }) {
  var _a, _b;
  const onSortOrderChange = useCallback(
    (item) => {
      const newSql = { ...sql, orderByDirection: item };
      onSqlChange(newSql);
    },
    [onSqlChange, sql]
  );
  const onLimitChange = useCallback(
    (event) => {
      const newSql = { ...sql, limit: Number.parseInt(event.currentTarget.value, 10) };
      onSqlChange(newSql);
    },
    [onSqlChange, sql]
  );
  const onOffsetChange = useCallback(
    (event) => {
      const newSql = { ...sql, offset: Number.parseInt(event.currentTarget.value, 10) };
      onSqlChange(newSql);
    },
    [onSqlChange, sql]
  );
  const onOrderByChange = useCallback(
    (item) => {
      const newSql = { ...sql, orderBy: setPropertyField(item == null ? undefined : item.value) };
      if (item === null) {
        newSql.orderByDirection = undefined;
      }
      onSqlChange(newSql);
    },
    [onSqlChange, sql]
  );
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(EditorField, { label: "Order by", width: 25, children: /* @__PURE__ */ jsxs(InputGroup, { children: [
      /* @__PURE__ */ jsx(
        Select,
        {
          "aria-label": "Order by",
          options: columns,
          value: ((_a = sql.orderBy) == null ? undefined : _a.property.name) ? toOption(sql.orderBy.property.name) : null,
          isClearable: true,
          menuShouldPortal: true,
          onChange: onOrderByChange
        }
      ),
      /* @__PURE__ */ jsx(Space, { h: 1.5 }),
      /* @__PURE__ */ jsx(
        RadioButtonGroup,
        {
          options: sortOrderOptions,
          disabled: !((_b = sql == null ? undefined : sql.orderBy) == null ? undefined : _b.property.name),
          value: sql.orderByDirection,
          onChange: onSortOrderChange
        }
      )
    ] }) }),
    /* @__PURE__ */ jsx(EditorField, { label: "Limit", optional: true, width: 25, children: /* @__PURE__ */ jsx(Input, { type: "number", min: 0, id: uniqueId("limit-"), value: sql.limit || "", onChange: onLimitChange }) }),
    showOffset && /* @__PURE__ */ jsx(EditorField, { label: "Offset", optional: true, width: 25, children: /* @__PURE__ */ jsx(Input, { type: "number", id: uniqueId("offset-"), value: sql.offset || "", onChange: onOffsetChange }) })
  ] });
}

export { OrderByRow };
//# sourceMappingURL=OrderByRow.js.map
