/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.core;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.Codec;
import org.gradle.internal.serialize.graph.CombinatorsKt;
import org.gradle.internal.serialize.graph.ReadContext;
import org.gradle.internal.serialize.graph.WriteContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u00020\u0002*\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/internal/serialize/codecs/core/RegularFileCodec;", "Lorg/gradle/internal/serialize/graph/Codec;", "Lorg/gradle/api/file/RegularFile;", "fileFactory", "Lorg/gradle/api/internal/file/FileFactory;", "<init>", "(Lorg/gradle/api/internal/file/FileFactory;)V", "encode", "", "Lorg/gradle/internal/serialize/graph/WriteContext;", "value", "(Lorg/gradle/internal/serialize/graph/WriteContext;Lorg/gradle/api/file/RegularFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "decode", "Lorg/gradle/internal/serialize/graph/ReadContext;", "(Lorg/gradle/internal/serialize/graph/ReadContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core-serialization-codecs"})
public final class RegularFileCodec
implements Codec<RegularFile> {
    @NotNull
    private final FileFactory fileFactory;

    public RegularFileCodec(@NotNull FileFactory fileFactory) {
        Intrinsics.checkNotNullParameter((Object)fileFactory, (String)"fileFactory");
        this.fileFactory = fileFactory;
    }

    @Nullable
    public Object encode(@NotNull WriteContext $this$encode, @NotNull RegularFile value, @NotNull Continuation<? super Unit> $completion) {
        Encoder encoder = (Encoder)$this$encode;
        File file = value.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        CombinatorsKt.writeFile((Encoder)encoder, (File)file);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object decode(@NotNull ReadContext $this$decode, @NotNull Continuation<? super RegularFile> $completion) {
        RegularFile regularFile = this.fileFactory.file(CombinatorsKt.readFile((Decoder)((Decoder)$this$decode)));
        Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"file(...)");
        return regularFile;
    }
}

