/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import javax.swing.ImageIcon;
import tim.prune.gui.IconManager;
import tim.prune.gui.map.WpIconDefinition;

public abstract class WpIconLibrary {
    public static final int WAYPT_DEFAULT = 0;
    public static final int WAYPT_RING_POINT = 1;
    public static final int WAYPT_PLECTRUM = 2;
    public static final int WAYPT_CIRCLE = 3;
    public static final int WAYPT_PIN = 4;
    public static final int WAYPT_FLAG = 5;
    public static final int WAYPT_NUMBER_OF_ICONS = 6;

    public static Integer[] getWaypointTypes() {
        return new Integer[]{0, 1, 2, 3, 4, 5};
    }

    public static String getIconName(int n) {
        switch (n) {
            case 1: {
                return "ringpt";
            }
            case 2: {
                return "plectrum";
            }
            case 3: {
                return "ring";
            }
            case 4: {
                return "pin";
            }
            case 5: {
                return "flag";
            }
        }
        return "default";
    }

    public static WpIconDefinition getIconDefinition(int n, int n2, IconManager iconManager) {
        return WpIconLibrary.getIconDefinition(n, Size.fromInt(n2), iconManager);
    }

    public static WpIconDefinition getFixedIconDefinition(int n, IconManager iconManager) {
        return WpIconLibrary.getIconDefinition(n, Size.FIXED, iconManager);
    }

    private static WpIconDefinition getIconDefinition(int n, Size size, IconManager iconManager) {
        String string = WpIconLibrary.getIconName(n);
        ImageIcon imageIcon = iconManager.getImageIcon("waypoints/wpicon_" + string + size.getSuffix());
        return new WpIconDefinition(imageIcon);
    }

    private static enum Size {
        SMALL("_s"),
        MEDIUM("_m"),
        LARGE("_l"),
        FIXED("_f");

        final String _suffix;

        private Size(String string2) {
            this._suffix = string2;
        }

        String getSuffix() {
            return this._suffix;
        }

        static Size fromInt(int n) {
            switch (n) {
                case 0: {
                    return SMALL;
                }
                default: {
                    return MEDIUM;
                }
                case 2: 
            }
            return LARGE;
        }
    }
}

