# frozen_string_literal: true

module GitlabQuality
  module TestTooling
    module Report
      module GroupIssues
        class IssueManager
          DEFAULT_MAX_AGE_HOURS = 24
          ISSUES_PER_PAGE = 50
          GROUPED_ISSUE_LABELS = Set.new(%w[test failure::test-environment automation:bot-authored type::maintenance]).freeze

          def initialize(options = {})
            @options = options
            @client = options[:gitlab]
            @issue_finder = IssueFinder.new(@client, @options)
            @issue_updater = IssueUpdater.new(@client, @options)
            @issue_creator = IssueCreator.new(@client, @options)
          end

          def create_or_update_issue(grouped_failure)
            existing_issue = @issue_finder.find_existing_issue(grouped_failure)

            if existing_issue
              @issue_updater.update_existing_issue(existing_issue, grouped_failure)
            else
              @issue_creator.create_new_issue(grouped_failure)
            end
          end
        end
      end
    end
  end
end
