---
stage: AI-powered
group: Agent Foundations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: SAST脆弱性解決フロー
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated
- ステータス: ベータ版

{{< /details >}}

{{< history >}}

- GitLab 18.9で、[ベータ](../../../../policy/development_stages_support.md#beta)機能として[導入](https://gitlab.com/groups/gitlab-org/-/epics/17889) [されました](../../../../administration/feature_flags/_index.md)。`enable_vulnerability_resolution`と`agentic_sast_vr_ui`という機能フラグが指定されています。デフォルトでは無効になっています。

{{< /history >}}

エージェント型SAST脆弱性解決は、SAST脆弱性を自動的に分析し、コンテキスト認識型のコード修正を含むマージリクエストを生成します。このエージェント型アプローチでは、マルチショット推論を使用して、人間の介入を最小限に抑えながら脆弱性を解決します。

SASTセキュリティスキャンがmainブランチで実行されると、GitLab Duoは重大度が高い、またはクリティカルな脆弱性を自動的に分析して、信頼性の高い修正を生成できるかどうかを判断します。分析はバックグラウンドで処理され、処理が完了すると、脆弱性レポートに結果が表示されます。

結果はAIによる分析に基づいており、セキュリティ担当者によるレビューが必要です。この機能を使用するには、有効なサブスクリプションのGitLab Duo Enterpriseが必要です。

## エージェント型SAST脆弱性解決の実行 {#running-agentic-sast-vulnerability-resolution}

このフローは、特定の条件が満たされると自動的に実行されます。自動および手動実行の詳細については、[Agentic SAST脆弱性解決](../../../application_security/vulnerabilities/agentic_vulnerability_resolution.md)を参照してください。

## 関連リンク {#related-links}

- [Agentic SAST脆弱性解決](../../../application_security/vulnerabilities/agentic_vulnerability_resolution.md)。
- [脆弱性レポート](../../../application_security/vulnerability_report/_index.md)。
- [SAST](../../../application_security/sast/_index.md)。
- [GitLab Duo](../../../gitlab_duo/_index.md)。
