# frozen_string_literal: true

module Types
  module Authz
    module AccessTokens
      # rubocop:disable Graphql/AuthorizeTypes -- Authorization handled in the resolver
      class PermissionType < BaseObject
        graphql_name 'AccessTokenPermission'

        description 'Permission that belongs to a granular scope.'

        field :name,
          GraphQL::Types::String,
          null: false,
          description: 'Name of the permission.'

        field :description,
          GraphQL::Types::String,
          null: false,
          description: 'Description of the permission.'

        field :action,
          GraphQL::Types::String,
          null: false,
          description: 'Action of the permission.'

        field :resource,
          GraphQL::Types::String,
          null: false,
          description: 'Resource of the permission.'

        field :resource_name,
          GraphQL::Types::String,
          null: false,
          description: 'Display name of the resource.'

        field :resource_description, # rubocop: disable GraphQL/ExtractType -- no value for now
          GraphQL::Types::String,
          null: false,
          description: 'Description of the resource.'

        field :category,
          GraphQL::Types::String,
          null: false,
          description: 'Permission category.'

        field :category_name,
          GraphQL::Types::String,
          null: false,
          description: 'Display name of the permission category.'

        field :boundaries,
          [Types::Authz::AccessTokens::BoundaryEnum],
          null: false,
          description: 'List of resource types that the permission can be applied to.'
      end
      # rubocop:enable Graphql/AuthorizeTypes
    end
  end
end
