/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.space;

import db.DBHandle;
import db.DBRecord;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.memory.TraceRegisterContainer;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class AbstractDBTraceSpaceBasedManager<M extends DBTraceSpaceBased>
implements DBTraceManager {
    protected static final AddressSpace NO_ADDRESS_SPACE = Address.NO_ADDRESS.getAddressSpace();
    protected final String name;
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final DBTraceThreadManager threadManager;
    protected final DBCachedObjectStore<DBTraceSpaceEntry> spaceStore;
    protected final Map<AddressSpace, M> spaces = new TreeMap<AddressSpace, M>();
    protected final Map<TraceRegisterContainer, M> regSpacesByContainer = new HashMap<TraceRegisterContainer, M>();
    protected final Collection<M> spacesView = Collections.unmodifiableCollection(this.spaces.values());

    public AbstractDBTraceSpaceBasedManager(String name, DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws IOException, VersionException {
        this.name = name;
        this.dbh = dbh;
        this.lock = lock;
        this.baseLanguage = baseLanguage;
        this.trace = trace;
        this.threadManager = threadManager;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.spaceStore = factory.getOrCreateCachedStore(name + "Spaces", DBTraceSpaceEntry.class, DBTraceSpaceEntry::new, true);
    }

    protected String tableName(AddressSpace space) {
        return DBTraceUtils.tableName(this.name, space);
    }

    protected void loadSpaces() throws VersionException, IOException {
        HashMap<AddressSpace, TabledSpace> newSpaces = new HashMap<AddressSpace, TabledSpace>();
        for (TabledSpace tabledSpace : this.getTabledSpaces()) {
            newSpaces.put(tabledSpace.space(), tabledSpace);
        }
        this.spaces.keySet().retainAll(newSpaces.keySet());
        for (Map.Entry entry : newSpaces.entrySet()) {
            if (this.spaces.containsKey(entry.getKey())) continue;
            this.spaces.put((AddressSpace)entry.getKey(), this.createSpace((TabledSpace)entry.getValue()));
        }
    }

    protected AddressSpace getSpaceByName(AddressFactory factory, String name) {
        if (NO_ADDRESS_SPACE.getName().equals(name)) {
            return NO_ADDRESS_SPACE;
        }
        return factory.getAddressSpace(name);
    }

    protected List<TabledSpace> getTabledSpaces() {
        AddressFactory factory = this.trace.getBaseAddressFactory();
        ArrayList<TabledSpace> result = new ArrayList<TabledSpace>();
        for (DBTraceSpaceEntry ent : this.spaceStore.asMap().values()) {
            AddressSpace space = this.getSpaceByName(factory, ent.spaceName);
            if (space == null) {
                Msg.error((Object)this, (Object)("Space " + ent.spaceName + " does not exist in trace (language=" + String.valueOf(this.baseLanguage) + ")."));
                continue;
            }
            result.add(new TabledSpace(ent, space));
        }
        return result;
    }

    protected M getForSpace(AddressSpace space, boolean createIfAbsent) {
        this.trace.assertValidSpace(Objects.requireNonNull(space));
        if (!space.isMemorySpace() && !space.isRegisterSpace() && space != Address.NO_ADDRESS.getAddressSpace()) {
            throw new IllegalArgumentException("Space must be a memory, register, or NO_ADDRESS space");
        }
        if (!createIfAbsent) {
            try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
                DBTraceSpaceBased dBTraceSpaceBased = (DBTraceSpaceBased)this.spaces.get(space);
                return (M)dBTraceSpaceBased;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceSpaceBased dBTraceSpaceBased = this.spaces.computeIfAbsent(space, s -> {
                try {
                    DBTraceSpaceEntry ent = (DBTraceSpaceEntry)this.spaceStore.create();
                    ent.set(space.getName(), -1L, 0);
                    return this.createSpace(space, ent);
                }
                catch (VersionException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IOException e) {
                    this.dbError(e);
                    return null;
                }
            });
            return (M)dBTraceSpaceBased;
        }
    }

    protected M getForRegisterSpace(TraceThread thread, int frameLevel, boolean createIfAbsent) {
        this.trace.getThreadManager().assertIsMine(thread);
        TraceRegisterContainer container = TraceRegisterUtils.getRegisterContainer(thread.getObject(), frameLevel);
        return this.getForRegisterSpace(container, createIfAbsent);
    }

    protected M getForRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        TraceRegisterContainer container = TraceRegisterUtils.getRegisterContainer(frame);
        return this.getForRegisterSpace(container, createIfAbsent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private M doGetForRegisterSpaceFoundContainer(TraceRegisterContainer container, boolean createIfAbsent) {
        AddressSpace as = TraceRegisterUtils.getRegisterAddressSpace(container, createIfAbsent);
        if (!createIfAbsent) {
            try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
                if (as == null) {
                    M m = null;
                    return m;
                }
                M space = this.getForSpace(as, createIfAbsent);
                if (space == null) {
                    M m = null;
                    return m;
                }
                Map<TraceRegisterContainer, Object> map = this.regSpacesByContainer;
                synchronized (map) {
                    this.regSpacesByContainer.put(container, space);
                }
                map = space;
                return (M)map;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            M space = this.getForSpace(as, createIfAbsent);
            Map<TraceRegisterContainer, Object> map = this.regSpacesByContainer;
            synchronized (map) {
                this.regSpacesByContainer.put(container, space);
            }
            map = space;
            return (M)map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected M getForRegisterSpace(TraceRegisterContainer container, boolean createIfAbsent) {
        try (LockHold hold = LockHold.lock((Lock)(createIfAbsent ? this.lock.writeLock() : this.lock.readLock()));){
            if (container == null) {
                M m = null;
                return m;
            }
            Map<TraceRegisterContainer, M> map = this.regSpacesByContainer;
            synchronized (map) {
                DBTraceSpaceBased space = (DBTraceSpaceBased)this.regSpacesByContainer.get(container);
                if (space != null) {
                    DBTraceSpaceBased dBTraceSpaceBased = space;
                    return (M)dBTraceSpaceBased;
                }
            }
            M m = this.doGetForRegisterSpaceFoundContainer(container, createIfAbsent);
            return m;
        }
    }

    public DBTrace getTrace() {
        return this.trace;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public Language getBaseLanguage() {
        return this.baseLanguage;
    }

    public M get(AddressSpace space, boolean createIfAbsent) {
        return this.getForSpace(space, createIfAbsent);
    }

    public Collection<M> getActiveSpaces() {
        return this.spacesView;
    }

    protected abstract M createSpace(AddressSpace var1, DBTraceSpaceEntry var2) throws VersionException, IOException;

    private M createSpace(TabledSpace ts) throws VersionException, IOException {
        if (ts.entry.space != null) {
            return (M)ts.entry.space;
        }
        M space = this.createSpace(ts.space, ts.entry);
        ts.entry.space = space;
        return space;
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.regSpacesByContainer.clear();
            this.spaceStore.invalidateCache();
            this.loadSpaces();
            for (DBTraceSpaceBased m : this.spaces.values()) {
                m.invalidateCache();
            }
        }
        catch (VersionException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    @DBAnnotatedObjectInfo(version=1)
    public static class DBTraceSpaceEntry
    extends DBAnnotatedObject {
        static final String SPACE_COLUMN_NAME = "Space";
        @DBAnnotatedColumn(value="Space")
        static DBObjectColumn SPACE_COLUMN;
        @DBAnnotatedField(column="Space")
        private String spaceName;
        DBTraceSpaceBased space;

        public DBTraceSpaceEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        void set(String spaceName, long threadKey, int frameLevel) {
            this.spaceName = spaceName;
            this.update(SPACE_COLUMN);
        }
    }

    private record TabledSpace(DBTraceSpaceEntry entry, AddressSpace space) {
    }
}

