/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.Trace;
import ghidra.util.MathUtilities;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractMappedMemoryBytesVisitor {
    private final DebuggerStaticMappingService mappingService;
    private final byte[] buffer;

    public AbstractMappedMemoryBytesVisitor(DebuggerStaticMappingService mappingService, byte[] buffer) {
        this.mappingService = Objects.requireNonNull(mappingService);
        this.buffer = buffer;
    }

    protected AddressSetView includeFromProgram(Memory memory) {
        return memory.getLoadedAndInitializedAddressSet();
    }

    protected int read(Memory memory, Address addr, byte[] dest, int size) throws MemoryAccessException {
        return memory.getBytes(addr, dest, 0, size);
    }

    public boolean visit(Trace trace, long snap, AddressSetView hostView) throws MemoryAccessException {
        boolean result = false;
        for (Map.Entry ent : this.mappingService.getOpenMappedViews(trace, hostView, snap).entrySet()) {
            result |= this.visitProgram((Program)ent.getKey(), (Collection)ent.getValue());
        }
        return result;
    }

    protected boolean visitProgram(Program program, Collection<DebuggerStaticMappingService.MappedAddressRange> mappedSet) throws MemoryAccessException {
        boolean result = false;
        Memory memory = program.getMemory();
        AddressSetView included = this.includeFromProgram(memory);
        for (DebuggerStaticMappingService.MappedAddressRange mappedRng : mappedSet) {
            AddressRange progRng = mappedRng.getDestinationAddressRange();
            for (AddressRange subProgRng : included.intersectRange(progRng.getMinAddress(), progRng.getMaxAddress())) {
                result |= this.visitRange(program, subProgRng, mappedRng);
            }
        }
        return result;
    }

    protected boolean visitRange(Program program, AddressRange progRng, DebuggerStaticMappingService.MappedAddressRange mappedRng) throws MemoryAccessException {
        int len;
        Memory memory = program.getMemory();
        AddressSpace progSpace = progRng.getAddressSpace();
        long lower = progRng.getMinAddress().getOffset();
        for (long fullLen = progRng.getLength(); fullLen > 0L; fullLen -= (long)len) {
            len = MathUtilities.unsignedMin((int)this.buffer.length, (long)fullLen);
            Address progAddr = progSpace.getAddress(lower);
            int read = this.read(memory, progAddr, this.buffer, len);
            Address hostAddr = mappedRng.mapDestinationToSource(progAddr);
            this.visitData(hostAddr, this.buffer, read);
            lower += (long)len;
        }
        return true;
    }

    protected abstract void visitData(Address var1, byte[] var2, int var3);
}

