/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.conditiontestpanel;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import docking.widgets.conditiontestpanel.ConditionTestPanel;
import docking.widgets.conditiontestpanel.ConditionTestState;
import docking.widgets.conditiontestpanel.ConditionTester;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ConditionTestModel {
    private ArrayList<ConditionTester> tests;
    private Map<ConditionTester, ConditionTestState> map;
    private final ConditionTestPanel conditionTestPanel;
    private int completedTestCount = 0;
    private int errorCount = 0;
    private int warningCount = 0;
    private volatile ConditionTestRunner conditionTestRunner;
    private ConditionTester inProgressTest;
    private int skippedCount;

    public ConditionTestModel(ConditionTestPanel conditionTestPanel, List<ConditionTester> tests) {
        this.conditionTestPanel = conditionTestPanel;
        this.tests = new ArrayList<ConditionTester>(tests);
        this.map = new HashMap<ConditionTester, ConditionTestState>();
        for (ConditionTester conditionTest : tests) {
            ConditionTestState testState = new ConditionTestState(conditionTest);
            this.map.put(conditionTest, testState);
        }
    }

    public synchronized void runTests(TaskMonitor monitor) {
        if (this.conditionTestRunner != null) {
            return;
        }
        for (ConditionTester test : this.tests) {
            ConditionTestState testState = this.map.get(test);
            testState.setResult(null);
        }
        this.completedTestCount = 0;
        this.errorCount = 0;
        this.warningCount = 0;
        this.skippedCount = 0;
        this.updatePanel();
        this.conditionTestRunner = new ConditionTestRunner(monitor);
    }

    public void skipTests() {
        if (this.conditionTestRunner != null) {
            return;
        }
        for (ConditionTester test : this.tests) {
            ConditionTestState testState = this.map.get(test);
            testState.setResult(new ConditionResult(ConditionStatus.Skipped));
        }
        this.completedTestCount = this.tests.size();
        this.errorCount = 0;
        this.warningCount = 0;
        this.skippedCount = this.tests.size();
        this.notifyTestsCompleted();
    }

    public int getTestCount() {
        return this.tests.size();
    }

    public int getCompletedTestCount() {
        return this.completedTestCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    synchronized void conditionTestCompleted() {
        this.conditionTestRunner = null;
        this.notifyTestsCompleted();
    }

    synchronized void startingTest(ConditionTester test) {
        this.inProgressTest = test;
        this.updatePanel();
    }

    synchronized void endingTest(ConditionTester test, ConditionResult result) {
        this.inProgressTest = null;
        ConditionTestState state = this.map.get(test);
        state.setResult(result);
        ConditionStatus status = result.getStatus();
        if (status == ConditionStatus.Error) {
            ++this.errorCount;
        } else if (status == ConditionStatus.Warning || status == ConditionStatus.Cancelled) {
            ++this.warningCount;
        } else if (status == ConditionStatus.Skipped) {
            ++this.skippedCount;
        }
        ++this.completedTestCount;
        this.updatePanel();
    }

    public void skippingTest(ConditionTester test) {
        ConditionResult result = new ConditionResult(ConditionStatus.Skipped);
        this.endingTest(test, result);
    }

    private void notifyTestsCompleted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConditionTestModel.this.conditionTestPanel.testsCompleted();
            }
        });
    }

    private void updatePanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConditionTestModel.this.conditionTestPanel.update();
            }
        });
    }

    public List<ConditionTester> getTests() {
        return new ArrayList<ConditionTester>(this.tests);
    }

    public ConditionStatus getStatus(ConditionTester test) {
        ConditionTestState conditionTestState = this.map.get(test);
        return conditionTestState.getStatus();
    }

    public synchronized boolean isInProgress() {
        return this.conditionTestRunner != null;
    }

    public boolean isInProgress(ConditionTester test) {
        return test == this.inProgressTest;
    }

    public void setEnabled(ConditionTester test, boolean enabled) {
        ConditionTestState conditionTestState = this.map.get(test);
        conditionTestState.setEnabled(enabled);
    }

    public String getStatusMessage(ConditionTester test) {
        ConditionTestState conditionTestState = this.map.get(test);
        return conditionTestState.getStatusMessage();
    }

    synchronized void cancel() {
        if (this.conditionTestRunner != null) {
            this.conditionTestRunner.dispose();
        }
    }

    private class ConditionTestRunner
    extends Thread {
        private final TaskMonitor monitor;
        private boolean isDisposed;

        ConditionTestRunner(TaskMonitor monitor) {
            this.monitor = monitor;
            this.start();
        }

        @Override
        public void run() {
            for (ConditionTester test : ConditionTestModel.this.tests) {
                if (this.isDisposed) {
                    return;
                }
                this.monitor.clearCancelled();
                this.monitor.setMessage("");
                this.monitor.setProgress(0L);
                ConditionTestState conditionTestState = ConditionTestModel.this.map.get(test);
                if (conditionTestState.isEnabled()) {
                    ConditionResult result;
                    ConditionTestModel.this.startingTest(test);
                    try {
                        result = test.run(this.monitor);
                    }
                    catch (CancelledException e) {
                        result = new ConditionResult(ConditionStatus.Cancelled);
                    }
                    ConditionTestModel.this.endingTest(test, result);
                    continue;
                }
                ConditionTestModel.this.skippingTest(test);
            }
            ConditionTestModel.this.conditionTestCompleted();
        }

        void dispose() {
            this.isDisposed = true;
            this.monitor.cancel();
        }
    }
}

