/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTMatchMarkupItemTableDBAdapter;
import ghidra.feature.vt.api.impl.MarkupItemStorage;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.VTMarkupTypeFactory;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VTMatchMarkupItemTableDBAdapterV0
extends VTMatchMarkupItemTableDBAdapter {
    private Table table;

    public VTMatchMarkupItemTableDBAdapterV0(DBHandle dbHandle) throws IOException {
        this.table = dbHandle.createTable(TABLE_NAME, TABLE_SCHEMA, INDEXED_COLUMNS);
    }

    public VTMatchMarkupItemTableDBAdapterV0(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        this.table = dbHandle.getTable(TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: " + TABLE_NAME);
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table " + TABLE_NAME + " but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    public DBRecord createMarkupItemRecord(MarkupItemStorage markupItem) throws IOException {
        DBRecord record = TABLE_SCHEMA.createRecord(this.table.getKey());
        VTAssociationDB association = (VTAssociationDB)markupItem.getAssociation();
        VTSession manager = association.getSession();
        Program sourceProgram = manager.getSourceProgram();
        Program destinationProgram = manager.getDestinationProgram();
        record.setLongValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ASSOCIATION_KEY_COL.column(), association.getKey());
        record.setString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ADDRESS_SOURCE_COL.column(), markupItem.getDestinationAddressSource());
        record.setLongValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.SOURCE_ADDRESS_COL.column(), this.getAddressID(sourceProgram, markupItem.getSourceAddress()));
        Address destinationAddress = markupItem.getDestinationAddress();
        if (destinationAddress != null) {
            record.setLongValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.DESTINATION_ADDRESS_COL.column(), this.getAddressID(destinationProgram, markupItem.getDestinationAddress()));
        }
        record.setShortValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.MARKUP_TYPE_COL.column(), (short)VTMarkupTypeFactory.getID(markupItem.getMarkupType()));
        record.setString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.SOURCE_VALUE_COL.column(), Stringable.getString(markupItem.getSourceValue(), sourceProgram));
        record.setString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ORIGINAL_DESTINATION_VALUE_COL.column(), Stringable.getString(markupItem.getDestinationValue(), destinationProgram));
        record.setByteValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.STATUS_COL.column(), (byte)markupItem.getStatus().ordinal());
        this.table.putRecord(record);
        return record;
    }

    private long getAddressID(Program program, Address address) {
        AddressMap addressMap = program.getAddressMap();
        return addressMap.getKey(address, false);
    }

    @Override
    public void removeMarkupItemRecord(long key) throws IOException {
        this.table.deleteRecord(key);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public RecordIterator getRecords(long associationKey) throws IOException {
        LongField longField = new LongField(associationKey);
        return this.table.indexIterator(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ASSOCIATION_KEY_COL.column(), (Field)longField, (Field)longField, true);
    }

    @Override
    public DBRecord getRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecordCount();
    }
}

