/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import java.util.HashMap;
import java.util.Map;

public enum CallingConvention {
    UNKNOWN("INVALID", -1, "INVALID"),
    NEAR_C("__cdecl", 0, "near right to left push, caller pops stack"),
    FAR_C("__cdecl", 1, "far right to left push, caller pops stack"),
    NEAR_PASCAL("__pascal", 2, "near left to right push, callee pops stack"),
    FAR_PASCAL("__pascal", 3, "far left to right push, callee pops stack"),
    NEAR_FAST("__fastcall", 4, "near left to right push with regs, callee pops stack"),
    FAR_FAST("__fastcall", 5, "far left to right push with regs, callee pops stack"),
    SKIPPED("", 6, "skipped (unused) call index"),
    NEAR_STD("__stdcall", 7, "near standard call"),
    FAR_STD("__stdcall", 8, "far standard call"),
    NEAR_SYS("__syscall", 9, "near sys call"),
    FAR_SYS("__syscall", 10, "far sys call"),
    THISCALL("__thiscall", 11, "this call (this passed in register)"),
    MIPSCALL("", 12, "Mips call"),
    GENERIC("", 13, "Generic call sequence"),
    ALPHACALL("", 14, "Alpha call"),
    PPCCALL("", 15, "PPC call"),
    SHCALL("", 16, "Hitachi SuperH call"),
    ARMCALL("", 17, "ARM call"),
    AM33CALL("", 18, "AM33 call"),
    TRICALL("", 19, "TriCore Call"),
    SH5CALL("", 20, "Hitachi SuperH-5 call"),
    M32RCALL("", 21, "M32R Call"),
    CLRCALL("", 22, "clr call"),
    INLINE("", 23, "Marker for routines always inlined and thus lacking a convention"),
    NEAR_VECTOR("__vectorcall", 24, "near left to right push with regs, callee pops stack"),
    RESERVED("", 25, "first unused call enumeration");

    private static final Map<Integer, CallingConvention> BY_VALUE;
    private final String label;
    private final int value;
    private final String info;

    public String toString() {
        return this.label;
    }

    public int getValue() {
        return this.value;
    }

    public String getInfo() {
        return this.info;
    }

    public static CallingConvention fromValue(int val) {
        return BY_VALUE.getOrDefault(val, UNKNOWN);
    }

    private CallingConvention(String label, int value, String info) {
        this.label = label;
        this.value = value;
        this.info = info;
    }

    static {
        BY_VALUE = new HashMap<Integer, CallingConvention>();
        for (CallingConvention val : CallingConvention.values()) {
            BY_VALUE.put(val.value, val);
        }
    }
}

