/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.database.symbol.ClassSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

final class ObjectiveC2_Utilities {
    ObjectiveC2_Utilities() {
    }

    static long readNextIndex(BinaryReader reader, boolean is32bit) throws IOException {
        if (is32bit) {
            return reader.readNextUnsignedInt();
        }
        return reader.readNextLong();
    }

    static Namespace getNamespace(Program program, Namespace parentNamespace, String namespaceName) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = symbolTable.getNamespace(namespaceName, parentNamespace);
        if (namespace != null) {
            return namespace;
        }
        return symbolTable.createNameSpace(parentNamespace, namespaceName, SourceType.IMPORTED);
    }

    static Namespace getClassNamespace(Program program, Namespace parentNamespace, String namespaceName) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol symbol = symbolTable.getClassSymbol(namespaceName, parentNamespace);
        if (symbol instanceof ClassSymbol && symbol.getName().equals(namespaceName)) {
            return (GhidraClass)symbol.getObject();
        }
        return symbolTable.createClass(parentNamespace, namespaceName, SourceType.IMPORTED);
    }

    public static Symbol createSymbolUsingMemoryBlockAsNamespace(Program program, Address address, String name, SourceType sourceType) throws DuplicateNameException, InvalidInputException {
        Memory memory;
        MemoryBlock block;
        String namespaceName;
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = symbolTable.getNamespace(namespaceName = (block = (memory = program.getMemory()).getBlock(address)).getName(), program.getGlobalNamespace());
        if (namespace == null) {
            namespace = symbolTable.createNameSpace(program.getGlobalNamespace(), namespaceName, sourceType);
        }
        return symbolTable.createLabel(address, name, namespace, SourceType.ANALYSIS);
    }
}

