/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.widgets.combobox.GComboBox;
import docking.widgets.table.FocusableEditor;
import docking.widgets.textfield.HexDecimalModeTextField;
import generic.expressions.ExpressionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressEvaluator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import utility.function.Dummy;

public class AddressInput
extends JPanel
implements FocusableEditor {
    public static final Predicate<AddressSpace> ALL_MEMORY_SPACES = s -> s.isMemorySpace();
    public static final Predicate<AddressSpace> LOADED_MEMORY_SPACES = s -> s.isLoadedMemorySpace();
    private HexDecimalModeTextField textField;
    private AddressSpaceField addressSpaceField;
    AddressEvaluator addressEvaluator;
    private Predicate<AddressSpace> addressSpaceFilter = LOADED_MEMORY_SPACES;
    private Consumer<Address> addressChangedConsumer;
    private Consumer<String> addressErrorConsumer = Dummy.consumer();
    private boolean comboAdded;
    private boolean assumeHex = true;
    private boolean notificationsEnabled = true;
    private static final Comparator<AddressSpace> ADDRESS_SPACE_SORT_COMPARATOR = (s1, s2) -> {
        if (s1.isOverlaySpace()) {
            if (!s2.isOverlaySpace()) {
                return 1;
            }
        } else if (s2.isOverlaySpace()) {
            return -1;
        }
        return s1.getName().compareTo(s2.getName());
    };

    public AddressInput() {
        this(null, null, null);
    }

    public AddressInput(Consumer<Address> addressChangedConsumer) {
        this(null, null, addressChangedConsumer);
    }

    public AddressInput(Program program) {
        this(program, null, null);
    }

    public AddressInput(AddressFactory factory) {
        this(null, factory, null);
    }

    public AddressInput(Program program, Consumer<Address> addressChangedConsumer) {
        this(program, null, addressChangedConsumer);
    }

    public AddressInput(AddressFactory factory, Consumer<Address> addressChangedConsumer) {
        this(null, factory, addressChangedConsumer);
    }

    private AddressInput(Program program, AddressFactory factory, Consumer<Address> addressChangedConsumer) {
        this.addressChangedConsumer = Dummy.ifNull(addressChangedConsumer);
        this.buildComponent();
        if (program != null) {
            this.setProgram(program);
        } else if (factory != null) {
            this.setAddressFactory(factory);
        }
    }

    public void setAddressSpaceFilter(Predicate<AddressSpace> spaceFilter) {
        this.addressSpaceFilter = spaceFilter;
        this.updateAddressSpaceCombo();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void setComponentBorders(Border border) {
        this.addressSpaceField.setComponentsBorder(border);
        this.textField.setBorder(border);
    }

    public void setAssumeHex(boolean hexMode) {
        this.textField.setHexMode(hexMode);
        this.hexModeChanged(hexMode);
    }

    public void setAddress(Address address) {
        if (address.equals((Object)this.getAddress())) {
            return;
        }
        this.notificationsEnabled = false;
        try {
            Object addressString = address.toString(false);
            addressString = this.removeLeadingZeros((String)addressString);
            if (!this.assumeHex) {
                addressString = "0x" + (String)addressString;
            }
            this.textField.setText((String)addressString);
            this.addressSpaceField.setAddressSpace(address.getAddressSpace());
        }
        finally {
            this.notificationsEnabled = true;
        }
    }

    public void setAddressSpace(AddressSpace addressSpace) {
        this.addressSpaceField.setAddressSpace(addressSpace);
    }

    public Address getAddressWithExceptions() throws ExpressionException {
        String addrExpression = this.textField.getText();
        if (addrExpression.isBlank()) {
            return null;
        }
        return this.addressEvaluator.parseAsAddress(addrExpression);
    }

    public Address getAddress() {
        try {
            return this.getAddressWithExceptions();
        }
        catch (ExpressionException e) {
            return null;
        }
    }

    public AddressSpace getAddressSpace() {
        return this.addressSpaceField.getAddressSpace();
    }

    public boolean hasInput() {
        return !this.textField.getText().isBlank();
    }

    public String getText() {
        return this.textField.getText().trim();
    }

    public void setProgram(Program program) {
        this.addressEvaluator = new AddressEvaluator(program, this.assumeHex);
        this.updateAddressSpaceCombo();
    }

    public void setProgram(Program program, Predicate<AddressSpace> addessSpaceFilter) {
        this.addressSpaceFilter = addessSpaceFilter;
        this.setProgram(program);
    }

    public void setAddressFactory(AddressFactory factory) {
        this.addressEvaluator = new AddressEvaluator(factory, this.assumeHex);
        this.updateAddressSpaceCombo();
    }

    public void setAddressErrorConsumer(Consumer<String> addressErrorConsumer) {
        this.addressErrorConsumer = addressErrorConsumer;
    }

    public void clear() {
        this.textField.setText("");
    }

    public void select() {
        this.textField.selectAll();
    }

    public void simulateAddressChanged(Address addr) {
        this.setAddress(addr);
        this.notifyAddressChanged();
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public boolean containsAddressSpaces() {
        return this.comboAdded;
    }

    public void setAddressSpaceEditable(boolean state) {
        this.addressSpaceField.setEditable(state);
    }

    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.textField.removeActionListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.addressSpaceField.setEnabled(enabled);
    }

    public void setAccessibleName(String name) {
        this.textField.getAccessibleContext().setAccessibleName(name);
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
        this.addressSpaceField.setEditable(b);
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    public void focusEditor() {
        if (this.addressSpaceField.getSpaceCount() > 1 && this.addressSpaceField.isEnabled()) {
            this.addressSpaceField.requestFocusInWindow();
        } else {
            this.textField.requestFocusInWindow();
        }
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    private void buildComponent() {
        this.setLayout(new BorderLayout());
        this.textField = new HexDecimalModeTextField(10, b -> this.hexModeChanged((boolean)b));
        this.textField.setHexMode(true);
        this.textField.setName("JTextField");
        this.addressSpaceField = new AddressSpaceField();
        this.add((Component)this.textField, "Center");
        this.comboAdded = false;
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddressInput.this.notifyAddressChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddressInput.this.notifyAddressChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddressInput.this.notifyAddressChanged();
            }
        });
    }

    private void hexModeChanged(boolean hexMode) {
        this.assumeHex = hexMode;
        this.addressEvaluator.setAssumeHex(hexMode);
        this.notifyAddressChanged();
    }

    private String removeLeadingZeros(String addressString) {
        if (addressString.indexOf(":") >= 0) {
            return addressString;
        }
        for (int i = 0; i < addressString.length(); ++i) {
            if (addressString.charAt(i) == '0') continue;
            return addressString.substring(i);
        }
        return "0";
    }

    private void updateAddressSpaceCombo() {
        this.notificationsEnabled = false;
        try {
            this.addressSpaceField.updateAddressSpaces(this.addressEvaluator.getAddressFactory());
        }
        finally {
            this.notificationsEnabled = true;
        }
        this.addRemoveAdressSpaceField();
    }

    private void addRemoveAdressSpaceField() {
        this.remove(this.addressSpaceField);
        if (this.addressSpaceField.getSpaceCount() > 1) {
            this.add((Component)this.addressSpaceField, "West");
        }
        this.revalidate();
    }

    private void notifyAddressChanged() {
        if (this.notificationsEnabled) {
            try {
                Address address = this.getAddressWithExceptions();
                this.addressChangedConsumer.accept(address);
            }
            catch (ExpressionException e) {
                this.addressChangedConsumer.accept(null);
                this.addressErrorConsumer.accept(e.getMessage());
            }
        }
    }

    private class AddressSpaceField
    extends JPanel {
        private JComboBox<AddressSpace> combo;
        private JTextField uneditableSpaceField;
        private CardLayout layout = new CardLayout();
        private boolean editable = true;

        private AddressSpaceField() {
            this.setLayout(this.layout);
            this.combo = new GComboBox();
            this.combo.setName("JComboBox");
            this.combo.getAccessibleContext().setAccessibleName("Address Space");
            this.combo.addActionListener(ev -> this.addressSpaceChanged());
            this.add(this.combo, "combo");
            this.uneditableSpaceField = new JTextField("");
            this.uneditableSpaceField.setEnabled(false);
            this.add((Component)this.uneditableSpaceField, "text");
        }

        private void addressSpaceChanged() {
            AddressSpace space = (AddressSpace)this.combo.getSelectedItem();
            AddressInput.this.addressEvaluator.setPreferredAddressSpace(space);
            AddressInput.this.notifyAddressChanged();
        }

        private void setEditable(boolean state) {
            this.editable = state;
            this.updateLayout();
        }

        private void updateLayout() {
            boolean showCombo = this.isEnabled() && this.editable;
            this.layout.show(this, showCombo ? "combo" : "text");
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.updateLayout();
        }

        private int getSpaceCount() {
            return this.combo.getModel().getSize();
        }

        private void updateAddressSpaces(AddressFactory addressFactory) {
            ComboBoxModel<AddressSpace> model = this.createAddressSpaceModel(addressFactory);
            this.combo.setModel(model);
            AddressSpace defaultAddressSpace = addressFactory.getDefaultAddressSpace();
            if (AddressInput.this.addressSpaceFilter.test(defaultAddressSpace)) {
                this.setAddressSpace(defaultAddressSpace);
            } else {
                this.setAddressSpace((AddressSpace)model.getElementAt(0));
            }
        }

        private AddressSpace getAddressSpace() {
            return (AddressSpace)this.combo.getSelectedItem();
        }

        private void setAddressSpace(AddressSpace addressSpace) {
            this.combo.setSelectedItem(addressSpace);
            String name = addressSpace.getName();
            this.uneditableSpaceField.setText(name);
            this.invalidate();
        }

        private void setComponentsBorder(Border border) {
            this.combo.setBorder(border);
            this.uneditableSpaceField.setBorder(border);
        }

        private ComboBoxModel<AddressSpace> createAddressSpaceModel(AddressFactory factory) {
            AddressSpace[] spaces = factory.getAddressSpaces();
            Arrays.sort(spaces, ADDRESS_SPACE_SORT_COMPARATOR);
            DefaultComboBoxModel<AddressSpace> model = new DefaultComboBoxModel<AddressSpace>();
            for (AddressSpace space : spaces) {
                if (!AddressInput.this.addressSpaceFilter.test(space)) continue;
                model.addElement(space);
            }
            return model;
        }
    }
}

