/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;

public class ParameterPieces {
    public Address address;
    public DataType type;
    public Varnode[] joinPieces;
    public boolean isThisPointer = false;
    public boolean hiddenReturnPtr = false;
    public boolean isIndirect = false;

    public void swapMarkup(ParameterPieces op) {
        boolean tmpHidden = this.hiddenReturnPtr;
        boolean tmpIndirect = this.isIndirect;
        boolean tmpThis = this.isThisPointer;
        DataType tmpType = this.type;
        Varnode[] tmpJoin = this.joinPieces;
        this.hiddenReturnPtr = op.hiddenReturnPtr;
        this.isIndirect = op.isIndirect;
        this.isThisPointer = op.isThisPointer;
        this.type = op.type;
        this.joinPieces = op.joinPieces;
        op.hiddenReturnPtr = tmpHidden;
        op.isIndirect = tmpIndirect;
        op.isThisPointer = tmpThis;
        op.type = tmpType;
        op.joinPieces = tmpJoin;
    }

    public VariableStorage getVariableStorage(Program program) {
        DynamicVariableStorage store;
        if (this.type == null) {
            this.type = DataType.DEFAULT;
        }
        if (VoidDataType.isVoidDataType(this.type)) {
            if (this.isIndirect) {
                return DynamicVariableStorage.INDIRECT_VOID_STORAGE;
            }
            return VariableStorage.VOID_STORAGE;
        }
        int sz = this.type.getLength();
        if (sz == 0) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        if (this.isThisPointer) {
            try {
                if (this.address != null) {
                    return new DynamicVariableStorage((ProgramArchitecture)program, AutoParameterType.THIS, this.address, sz);
                }
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            return DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.THIS);
        }
        if ((this.address == null || this.address == Address.NO_ADDRESS) && this.joinPieces == null) {
            return DynamicVariableStorage.getUnassignedDynamicStorage(this.isIndirect);
        }
        try {
            store = this.joinPieces != null ? new DynamicVariableStorage((ProgramArchitecture)program, this.isIndirect, this.joinPieces) : (this.hiddenReturnPtr ? new DynamicVariableStorage((ProgramArchitecture)program, AutoParameterType.RETURN_STORAGE_PTR, this.address, sz) : new DynamicVariableStorage((ProgramArchitecture)program, this.isIndirect, this.address, sz));
        }
        catch (InvalidInputException e) {
            store = DynamicVariableStorage.getUnassignedDynamicStorage(this.isIndirect);
        }
        return store;
    }

    public static ArrayList<Varnode> mergeSequence(ArrayList<Varnode> seq, Language language) {
        Varnode lo;
        Varnode hi;
        int i;
        boolean bigEndian = language.isBigEndian();
        for (i = 1; i < seq.size() && !(hi = seq.get(i - 1)).isContiguous(lo = seq.get(i), bigEndian); ++i) {
        }
        if (i >= seq.size()) {
            return seq;
        }
        ArrayList<Varnode> buffer = new ArrayList<Varnode>();
        buffer.add(seq.getFirst());
        boolean lastIsInformal = false;
        for (i = 1; i < seq.size(); ++i) {
            Varnode lo2;
            Varnode hi2 = (Varnode)buffer.getLast();
            if (hi2.isContiguous(lo2 = seq.get(i), bigEndian)) {
                long off = bigEndian ? hi2.getOffset() : lo2.getOffset();
                int sz = hi2.getSize() + lo2.getSize();
                Varnode newVn = new Varnode(hi2.getAddress().getAddressSpace().getAddress(off), sz);
                buffer.removeLast();
                buffer.add(newVn);
                if (newVn.getAddress().isStackAddress()) continue;
                lastIsInformal = language.getRegister(newVn.getAddress(), newVn.getSize()) == null;
                continue;
            }
            if (lastIsInformal) break;
            buffer.add(lo2);
        }
        if (lastIsInformal) {
            return seq;
        }
        return buffer;
    }

    public void assignAddressFromPieces(ArrayList<Varnode> pieces, boolean mostToLeast, boolean onePieceJoin, Language language) {
        if (!mostToLeast && pieces.size() > 1) {
            ArrayList<Varnode> reverse = new ArrayList<Varnode>();
            for (int i = pieces.size() - 1; i >= 0; --i) {
                reverse.add(pieces.get(i));
            }
            pieces = reverse;
        }
        if ((pieces = ParameterPieces.mergeSequence(pieces, language)).size() == 1 && !onePieceJoin) {
            this.address = pieces.get(0).getAddress();
            return;
        }
        this.joinPieces = new Varnode[pieces.size()];
        pieces.toArray(this.joinPieces);
        this.address = Address.NO_ADDRESS;
    }
}

