/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghpatexpress.ContextField;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class ContextSymbol
extends ValueSymbol {
    private VarnodeSymbol vn;
    private int low;
    private int high;
    private boolean flow;

    public ContextSymbol(Location location) {
        super(location);
    }

    public VarnodeSymbol getVarnode() {
        return this.vn;
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    public boolean isFlow() {
        return this.flow;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.context_symbol;
    }

    public ContextSymbol(Location location, String nm, ContextField pate, VarnodeSymbol v, int l, int h, boolean flow) {
        super(location, nm, pate);
        this.vn = v;
        this.low = l;
        this.high = h;
        this.flow = flow;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_CONTEXT_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_VARNODE, this.vn.getId());
        encoder.writeSignedInteger(SlaFormat.ATTRIB_LOW, this.low);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_HIGH, this.high);
        encoder.writeBool(SlaFormat.ATTRIB_FLOW, this.flow);
        this.patval.encode(encoder);
        encoder.closeElement(SlaFormat.ELEM_CONTEXT_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_CONTEXT_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_CONTEXT_SYM_HEAD);
    }
}

