/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CustomizationTab
extends Composite {
    private final INavigatorContentService contentService;
    private CheckboxTableViewer tableViewer;
    private final Set checkedItems = new HashSet();
    private final ICheckStateListener checkListener = this::checkStateChanged;

    protected CustomizationTab(Composite parent, INavigatorContentService aContentService) {
        super(parent, 16);
        this.contentService = aContentService;
        this.setFont(this.getParent().getFont());
        this.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        this.setData(data);
    }

    protected Table getTable() {
        return this.tableViewer.getTable();
    }

    protected void addSelectionChangedListener(ISelectionChangedListener selectionListener) {
        if (this.tableViewer != null) {
            this.tableViewer.addSelectionChangedListener(selectionListener);
        }
    }

    protected void createTable() {
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2816);
        this.tableViewer.addCheckStateListener(this.checkListener);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getControl().setFont(this.getFont());
    }

    public void dispose() {
        this.tableViewer.removeCheckStateListener(this.checkListener);
        super.dispose();
    }

    protected void createInstructionsLabel(String labelText) {
        Label extensionsInstructionLabel = new Label((Composite)this, 65);
        GridData gridData = new GridData(784);
        extensionsInstructionLabel.setLayoutData((Object)gridData);
        extensionsInstructionLabel.setFont(this.getFont());
        extensionsInstructionLabel.setText(labelText);
    }

    protected final INavigatorContentService getContentService() {
        return this.contentService;
    }

    protected final CheckboxTableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected Set getCheckedItems() {
        return this.checkedItems;
    }

    protected void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            this.checkedItems.add(event.getElement());
        } else {
            this.checkedItems.remove(event.getElement());
        }
    }
}

