/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.util.List;
import org.cts.crs.CoordinateReferenceSystem;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.gis.panel.ManageCRSDialog;
import org.jkiss.dbeaver.ui.gis.panel.ShowSRIDDialog;
import org.jkiss.utils.CommonUtils;

public class SelectSRIDDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.SelectSRIDDialog";
    private static final int MANAGE_BUTTON_ID = 1000;
    private int selectedSRID;
    private Combo sridCombo;
    private List<Integer> allSupportedCodes;
    private Text crsNameText;
    private Button detailsButton;

    public SelectSRIDDialog(Shell shell, int defCRS) {
        super(shell, GISMessages.panel_select_srid_dialog_title, null);
        this.selectedSRID = defCRS;
        this.allSupportedCodes = GisTransformUtils.getSortedEPSGCodes();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Composite crsGroup = UIUtils.createTitledComposite((Composite)dialogArea, (String)"CRS", (int)2, (int)768);
        crsGroup.setLayoutData((Object)new GridData(1808));
        this.sridCombo = UIUtils.createLabelCombo((Composite)crsGroup, (String)GISMessages.panel_select_srid_dialog_label_combo_source_srid, (String)GISMessages.panel_select_srid_dialog_label_combo_tooltip_source_crs, (int)2052);
        this.sridCombo.setLayoutData((Object)new GridData(768));
        this.sridCombo.setItems(new String[0]);
        String[] items = new String[this.allSupportedCodes.size()];
        for (int i = 0; i < this.allSupportedCodes.size(); ++i) {
            String strCode;
            Integer code = this.allSupportedCodes.get(i);
            items[i] = strCode = String.valueOf(code);
        }
        this.sridCombo.setItems(items);
        if (this.selectedSRID != 0) {
            this.sridCombo.setText(String.valueOf(this.selectedSRID));
        }
        this.sridCombo.addModifyListener(e -> {
            int newSRID = CommonUtils.toInt((Object)this.sridCombo.getText());
            this.setSelectedSRID(newSRID);
            this.updateButtons();
        });
        this.crsNameText = UIUtils.createLabelText((Composite)crsGroup, (String)GISMessages.panel_select_srid_dialog_title_label_text_name, (String)"", (int)2056);
        this.crsNameText.setLayoutData((Object)new GridData(768));
        UIUtils.createEmptyLabel((Composite)crsGroup, (int)1, (int)1);
        this.detailsButton = UIUtils.createPushButton((Composite)crsGroup, (String)GISMessages.panel_select_srid_dialog_button_label_details, null);
        this.detailsButton.setLayoutData((Object)new GridData(32));
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowSRIDDialog showSRIDDialog = new ShowSRIDDialog(SelectSRIDDialog.this.getShell(), SelectSRIDDialog.this.getSelectedSRID());
                showSRIDDialog.open();
            }
        });
        this.setSelectedSRID(this.selectedSRID);
        return dialogArea;
    }

    private void setSelectedSRID(int newSRID) {
        if (this.allSupportedCodes.contains(newSRID)) {
            this.selectedSRID = newSRID;
            try {
                CoordinateReferenceSystem crs = GisTransformUtils.getCRSFactory().getCRS("EPSG:" + this.selectedSRID);
                this.crsNameText.setText(CommonUtils.notEmpty((String)crs.getName()) + " (" + String.valueOf(crs.getCoordinateSystem()) + ")");
                this.detailsButton.setEnabled(true);
            }
            catch (Throwable e) {
                DBWorkbench.getPlatformUI().showError("Bad CRS", "Error reading CRS info", e);
            }
        } else {
            this.selectedSRID = 0;
            this.crsNameText.setText("N/A");
            this.detailsButton.setEnabled(false);
        }
    }

    protected Control createContents(@NotNull Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtons();
        return contents;
    }

    private void updateButtons() {
        this.enableButton(0, this.selectedSRID != 0);
    }

    public int getSelectedSRID() {
        return this.selectedSRID;
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 1000, GISMessages.panel_select_srid_dialog_button_label_manage, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1000) {
            int newSRID;
            ManageCRSDialog dialog = new ManageCRSDialog(this.getShell(), this.selectedSRID);
            if (dialog.open() == 0 && (newSRID = dialog.getSelectedSRID()) != 0) {
                this.sridCombo.setText(String.valueOf(newSRID));
                this.setSelectedSRID(newSRID);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }
}

