/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.Util;
import javax.el.ValueExpression;

public class LambdaExpression {
    private final List<String> formalParameters;
    private final ValueExpression expression;
    private final Map<String, Object> nestedArguments = new HashMap<String, Object>();
    private ELContext context = null;

    public LambdaExpression(List<String> list, ValueExpression valueExpression) {
        this.formalParameters = list;
        this.expression = valueExpression;
    }

    public void setELContext(ELContext eLContext) {
        this.context = eLContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ELContext eLContext, Object ... objectArray) throws ELException {
        Objects.requireNonNull(eLContext);
        int n = 0;
        if (this.formalParameters != null) {
            n = this.formalParameters.size();
        }
        int n2 = 0;
        if (objectArray != null) {
            n2 = objectArray.length;
        }
        if (n > n2) {
            throw new ELException(Util.message(eLContext, "lambdaExpression.tooFewArgs", n2, n));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.nestedArguments);
        for (int i = 0; i < n; ++i) {
            hashMap.put(this.formalParameters.get(i), objectArray[i]);
        }
        eLContext.enterLambdaScope(hashMap);
        try {
            Object object = this.expression.getValue(eLContext);
            if (object instanceof LambdaExpression) {
                ((LambdaExpression)object).nestedArguments.putAll(hashMap);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            eLContext.exitLambdaScope();
        }
    }

    public Object invoke(Object ... objectArray) {
        return this.invoke(this.context, objectArray);
    }
}

