/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.geom.PathIterator;

final class DecimatedPathIterator
implements PathIterator {
    private final PathIterator source;
    private final double xRes;
    private final double yRes;
    private double px;
    private double py;

    DecimatedPathIterator(PathIterator pathIterator, double d, double d2) {
        this.source = pathIterator;
        this.xRes = d;
        this.yRes = d2;
        this.py = Double.NaN;
        this.px = Double.NaN;
    }

    @Override
    public void next() {
        this.source.next();
    }

    @Override
    public boolean isDone() {
        return this.source.isDone();
    }

    @Override
    public int getWindingRule() {
        return this.source.getWindingRule();
    }

    @Override
    public int currentSegment(double[] dArray) {
        do {
            int n = this.source.currentSegment(dArray);
            switch (n) {
                default: {
                    this.py = Double.NaN;
                    this.px = Double.NaN;
                    return n;
                }
                case 0: {
                    this.px = dArray[0];
                    this.py = dArray[1];
                    return 0;
                }
                case 1: 
            }
            if (this.include(dArray[0], dArray[1])) {
                return 1;
            }
            this.source.next();
        } while (!this.source.isDone());
        dArray[0] = this.px;
        dArray[1] = this.py;
        return 1;
    }

    @Override
    public int currentSegment(float[] fArray) {
        do {
            int n = this.source.currentSegment(fArray);
            switch (n) {
                default: {
                    this.py = Double.NaN;
                    this.px = Double.NaN;
                    return n;
                }
                case 0: {
                    this.px = fArray[0];
                    this.py = fArray[1];
                    return 0;
                }
                case 1: 
            }
            if (this.include(fArray[0], fArray[1])) {
                return 1;
            }
            this.source.next();
        } while (!this.source.isDone());
        fArray[0] = (float)this.px;
        fArray[1] = (float)this.py;
        return 1;
    }

    private boolean include(double d, double d2) {
        if (Math.abs(this.px - d) < this.xRes && Math.abs(this.py - d2) < this.yRes) {
            return false;
        }
        this.px = d;
        this.py = d2;
        return true;
    }
}

