/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.function.BiConsumer;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.image.FormatFinder;
import org.apache.sis.internal.storage.image.WarningListener;
import org.apache.sis.internal.storage.image.WorldFileResource;
import org.apache.sis.internal.storage.image.WorldFileStore;
import org.apache.sis.internal.storage.image.WritableResource;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.operation.MathTransform;

class WritableStore
extends WorldFileStore {
    private final long streamBeginning;
    private ImageWriter writer;
    private int numImages;

    WritableStore(FormatFinder formatFinder) throws DataStoreException, IOException {
        super(formatFinder, false);
        if (this.getCurrentReader() != null) {
            this.numImages = -1;
        } else {
            this.writer = formatFinder.getOrCreateWriter();
            if (this.writer == null) {
                throw new UnsupportedStorageException(super.getLocale(), "World file", formatFinder.storage, formatFinder.connector.getOption(OptionKey.OPEN_OPTIONS));
            }
            this.configureWriter();
            if (!formatFinder.fileIsEmpty) {
                this.numImages = -1;
            }
        }
        this.streamBeginning = formatFinder.storage instanceof ImageInputStream ? ((ImageInputStream)formatFinder.storage).getStreamPosition() : 0L;
    }

    private void configureWriter() {
        try {
            this.writer.setLocale(this.listeners.getLocale());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.writer.addIIOWriteWarningListener(new WarningListener(this.listeners));
    }

    @Override
    public String[] getImageFormat(boolean bl) {
        ImageWriterSpi imageWriterSpi;
        if (this.writer != null && (imageWriterSpi = this.writer.getOriginatingProvider()) != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = bl ? imageWriterSpi.getMIMETypes() : imageWriterSpi.getFormatNames();
            if (stringArray != null) {
                return stringArray;
            }
        }
        return super.getImageFormat(bl);
    }

    final int isMultiImages() throws IOException, DataStoreException {
        if (this.numImages < 0) {
            WorldFileStore.Components components = this.components(true, this.numImages);
            if (components.isEmpty()) {
                this.numImages = 0;
            } else {
                if (components.exists(1)) {
                    return 2;
                }
                this.numImages = 1;
            }
        }
        return this.numImages;
    }

    @Override
    String setGridGeometry(int n, GridGeometry gridGeometry) throws IOException, DataStoreException {
        String string;
        assert (Thread.holdsLock(this));
        GridExtent gridExtent = gridGeometry.getExtent();
        long[] lArray = new long[gridExtent.getDimension()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = Math.negateExact(gridExtent.getLow(i));
        }
        gridGeometry = gridGeometry.translate(lArray);
        if (!(n == 0 && this.isMultiImages() <= 1 || this.getGridGeometry(0).equals(gridGeometry, ComparisonMode.IGNORE_METADATA))) {
            throw new IncompatibleResourceException(this.resources().getString((short)72));
        }
        AffineTransform affineTransform = null;
        if (gridGeometry.isDefined(8)) {
            try {
                affineTransform = AffineTransforms2D.castOrCopy((MathTransform)gridGeometry.getGridToCRS(CELL_ANCHOR));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IncompatibleResourceException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
            }
        }
        if ((string = super.setGridGeometry(n, gridGeometry)) != null) {
            block24: {
                if (affineTransform == null) {
                    this.deleteAuxiliaryFile(string);
                } else {
                    try (BufferedWriter bufferedWriter = this.writeAuxiliaryFile(string);){
                        int n2 = 0;
                        while (true) {
                            double d;
                            switch (n2) {
                                case 0: {
                                    d = affineTransform.getScaleX();
                                    break;
                                }
                                case 1: {
                                    d = affineTransform.getShearY();
                                    break;
                                }
                                case 2: {
                                    d = affineTransform.getShearX();
                                    break;
                                }
                                case 3: {
                                    d = affineTransform.getScaleY();
                                    break;
                                }
                                case 4: {
                                    d = affineTransform.getTranslateX();
                                    break;
                                }
                                case 5: {
                                    d = affineTransform.getTranslateY();
                                    break;
                                }
                                default: {
                                    break block24;
                                }
                            }
                            bufferedWriter.write(Double.toString(d));
                            bufferedWriter.newLine();
                            ++n2;
                        }
                    }
                }
            }
            this.writePRJ();
        }
        return string;
    }

    @Override
    WorldFileResource createImageResource(int n) throws DataStoreException, IOException {
        return new WritableResource(this, this.listeners, n, this.getGridGeometry(n));
    }

    public synchronized Resource add(Resource resource) throws DataStoreException {
        Exception exception = null;
        if (resource instanceof GridCoverageResource) {
            try {
                WorldFileStore.Components components = this.components(true, this.numImages);
                if (this.numImages < 0) {
                    this.numImages = components.size();
                }
                GridGeometry gridGeometry = null;
                if (this.numImages != 0) {
                    gridGeometry = this.getGridGeometry(0);
                }
                GridCoverage gridCoverage = ((GridCoverageResource)resource).read(gridGeometry, null);
                if (gridGeometry == null) {
                    gridGeometry = gridCoverage.getGridGeometry();
                }
                WritableResource writableResource = new WritableResource(this, this.listeners, this.numImages, gridGeometry);
                writableResource.write(gridCoverage, new WritableGridCoverageResource.Option[0]);
                components.added(writableResource);
                ++this.numImages;
                return writableResource;
            }
            catch (IOException | RuntimeException exception2) {
                exception = exception2;
            }
        }
        throw new DataStoreException(this.resources().getString((short)69, WritableStore.label(resource)), exception);
    }

    @Override
    public synchronized void remove(Resource resource) throws DataStoreException {
        WritableResource writableResource;
        Exception exception = null;
        if (resource instanceof WritableResource && (writableResource = (WritableResource)resource).store() == this) {
            try {
                int n = writableResource.getImageIndex();
                this.writer().removeImage(n);
                WorldFileStore.Components components = this.components(false, this.numImages);
                if (components != null) {
                    components.removed(n);
                    writableResource.dispose();
                    --this.numImages;
                }
            }
            catch (IOException | RuntimeException exception2) {
                exception = exception2;
            }
        }
        throw new DataStoreException(this.resources().getString((short)49, this.getDisplayName(), WritableStore.label(resource)), exception);
    }

    private static String label(Resource resource) throws DataStoreException {
        return resource.getIdentifier().map(Object::toString).orElse("?");
    }

    @Override
    ImageReader prepareReader(ImageReader imageReader) throws IOException {
        Object object;
        ImageWriter imageWriter = this.writer;
        if (imageWriter != null && (object = imageWriter.getOutput()) != null) {
            ImageReaderSpi imageReaderSpi;
            ImageWriterSpi imageWriterSpi;
            if (imageReader == null && (imageWriterSpi = imageWriter.getOriginatingProvider()) != null && (imageReaderSpi = this.getProviderByClass(ImageReaderSpi.class, imageWriterSpi.getImageReaderSpiNames(), imageWriterSpi)) != null) {
                imageReader = imageReaderSpi.createReaderInstance();
            }
            if (imageReader != null) {
                imageWriter.setOutput(null);
                this.setStream(imageReader, object, ImageReader::setInput);
                return imageReader;
            }
        }
        return null;
    }

    final ImageWriter writer() throws DataStoreException, IOException {
        Object object;
        assert (Thread.holdsLock(this));
        ImageWriter imageWriter = this.writer;
        if (imageWriter != null && imageWriter.getOutput() != null) {
            return imageWriter;
        }
        ImageReader imageReader = this.getCurrentReader();
        if (imageReader != null && (object = imageReader.getInput()) != null) {
            ImageWriterSpi imageWriterSpi;
            ImageReaderSpi imageReaderSpi;
            if (imageWriter == null && (imageReaderSpi = imageReader.getOriginatingProvider()) != null && (imageWriterSpi = this.getProviderByClass(ImageWriterSpi.class, imageReaderSpi.getImageWriterSpiNames(), imageReaderSpi)) != null) {
                imageWriter = imageWriterSpi.createWriterInstance();
            }
            if (imageWriter != null) {
                imageReader.setInput(null);
                this.setStream(imageWriter, object, ImageWriter::setOutput);
                this.writer = imageWriter;
                this.configureWriter();
                return imageWriter;
            }
        }
        throw new DataStoreClosedException(this.getLocale(), "World file", StandardOpenOption.WRITE);
    }

    private <T> void setStream(T t, Object object, BiConsumer<T, Object> biConsumer) throws IOException {
        try {
            if (object instanceof ImageInputStream) {
                ((ImageInputStream)object).seek(this.streamBeginning);
            }
            biConsumer.accept(t, object);
        }
        catch (Throwable throwable) {
            if (object instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)object).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    private <T extends ImageReaderWriterSpi> T getProviderByClass(Class<T> clazz, String[] stringArray, ImageReaderWriterSpi imageReaderWriterSpi) {
        if (stringArray != null) {
            IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
            ClassLoader classLoader = imageReaderWriterSpi.getClass().getClassLoader();
            for (String string : stringArray) {
                Class<T> clazz2;
                try {
                    clazz2 = Class.forName(string, true, classLoader).asSubclass(clazz);
                }
                catch (ClassCastException | ClassNotFoundException exception) {
                    this.listeners.warning(exception);
                    continue;
                }
                ImageReaderWriterSpi imageReaderWriterSpi2 = (ImageReaderWriterSpi)iIORegistry.getServiceProviderByClass(clazz2);
                if (imageReaderWriterSpi2 == null) continue;
                return (T)imageReaderWriterSpi2;
            }
        }
        return null;
    }

    @Override
    public synchronized void close() throws DataStoreException {
        block8: {
            try {
                ImageWriter imageWriter = this.writer;
                this.writer = null;
                if (imageWriter == null) break block8;
                try {
                    Object object = imageWriter.getOutput();
                    imageWriter.setOutput(null);
                    imageWriter.dispose();
                    if (object instanceof AutoCloseable) {
                        ((AutoCloseable)object).close();
                    }
                }
                catch (Exception exception) {
                    throw new DataStoreException(exception);
                }
            }
            finally {
                super.close();
            }
        }
    }
}

