/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.llm.textvectorisation.update.processor;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.llm.textvectorisation.model.SolrTextToVectorModel;
import org.apache.solr.llm.textvectorisation.store.rest.ManagedTextToVectorModelStore;
import org.apache.solr.llm.textvectorisation.update.processor.TextToVectorUpdateProcessor;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class TextToVectorUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final String INPUT_FIELD_PARAM = "inputField";
    private static final String OUTPUT_FIELD_PARAM = "outputField";
    private static final String MODEL_NAME = "model";
    private String inputField;
    private String outputField;
    private String modelName;
    private SolrParams params;

    public void init(NamedList<?> args) {
        this.params = args.toSolrParams();
        RequiredSolrParams required = this.params.required();
        this.inputField = required.get(INPUT_FIELD_PARAM);
        this.outputField = required.get(OUTPUT_FIELD_PARAM);
        this.modelName = required.get(MODEL_NAME);
    }

    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        IndexSchema latestSchema = req.getCore().getLatestSchema();
        if (!latestSchema.isDynamicField(this.inputField) && !latestSchema.hasExplicitField(this.inputField)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "undefined field: \"" + this.inputField + "\"");
        }
        if (!latestSchema.isDynamicField(this.outputField) && !latestSchema.hasExplicitField(this.outputField)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "undefined field: \"" + this.outputField + "\"");
        }
        SchemaField outputFieldSchema = latestSchema.getField(this.outputField);
        this.assertIsDenseVectorField(outputFieldSchema);
        ManagedTextToVectorModelStore modelStore = ManagedTextToVectorModelStore.getManagedModelStore(req.getCore());
        SolrTextToVectorModel textToVector = modelStore.getModel(this.modelName);
        if (textToVector == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The model configured in the Update Request Processor '" + this.modelName + "' can't be found in the store: /schema/text-to-vector-model-store");
        }
        return new TextToVectorUpdateProcessor(this.inputField, this.outputField, textToVector, req, next);
    }

    protected void assertIsDenseVectorField(SchemaField schemaField) {
        FieldType fieldType = schemaField.getType();
        if (!(fieldType instanceof DenseVectorField)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "only DenseVectorField is compatible with Vector Query Parsers: " + schemaField.getName());
        }
    }

    public String getInputField() {
        return this.inputField;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public String getModelName() {
        return this.modelName;
    }
}

