/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.semver4j.Semver;

@NullMarked
public class Range {
    private final Semver rangeVersion;
    private final RangeOperator rangeOperator;

    public Range(Semver rangeVersion, RangeOperator rangeOperator) {
        this.rangeVersion = rangeVersion;
        this.rangeOperator = rangeOperator;
    }

    public Range(String rangeVersion, RangeOperator rangeOperator) {
        this(new Semver(rangeVersion), rangeOperator);
    }

    public Semver getRangeVersion() {
        return this.rangeVersion;
    }

    public boolean isSatisfiedByAny() {
        return this.rangeVersion.isEqualTo(Semver.ZERO) && this.rangeOperator == RangeOperator.GTE;
    }

    public boolean isSatisfiedBy(String version) {
        return this.isSatisfiedBy(new Semver(version));
    }

    public boolean isSatisfiedBy(Semver version) {
        switch (this.rangeOperator) {
            case EQ: {
                return version.isEquivalentTo(this.rangeVersion);
            }
            case LT: {
                return version.isLowerThan(this.rangeVersion);
            }
            case LTE: {
                return version.isLowerThanOrEqualTo(this.rangeVersion);
            }
            case GT: {
                return version.isGreaterThan(this.rangeVersion);
            }
            case GTE: {
                return version.isGreaterThanOrEqualTo(this.rangeVersion);
            }
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown RangeOperator: %s", new Object[]{this.rangeOperator}));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.rangeVersion, range.rangeVersion) && this.rangeOperator == range.rangeOperator;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rangeVersion, this.rangeOperator});
    }

    public String toString() {
        return this.rangeOperator.asString() + this.rangeVersion;
    }

    public static enum RangeOperator {
        EQ("="),
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">=");

        private final String string;

        private RangeOperator(String string2) {
            this.string = string2;
        }

        public String asString() {
            return this.string;
        }

        public static RangeOperator value(String string) {
            if (string.isEmpty()) {
                return EQ;
            }
            return Arrays.stream(RangeOperator.values()).filter(rangeOperator -> rangeOperator.asString().equals(string)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(Locale.ROOT, "Range operator for '%s' not found", string)));
        }
    }
}

