/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.date;

import com.epam.parso.date.NotImplementedException;
import com.epam.parso.date.SasTemporalConstants;
import com.epam.parso.date.SasTemporalFormat;
import com.epam.parso.date.SasTemporalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum SasTimeFormat implements SasTemporalFormat
{
    TIME(8){

        private BigDecimal[] roundSeconds(double sasSeconds, int width, int precision, int minIntegralWidth) {
            BigDecimal bigSeconds = new BigDecimal(sasSeconds).abs();
            while (true) {
                BigDecimal[] parts = bigSeconds.setScale(precision, RoundingMode.HALF_UP).divideAndRemainder(SasTemporalConstants.BIG_SECONDS_IN_HOUR);
                if (precision == 0) {
                    return parts;
                }
                String hh = String.valueOf(parts[0].longValue());
                if (hh.length() + minIntegralWidth + precision <= width) {
                    return parts;
                }
                --precision;
            }
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return sasSeconds -> {
                boolean negative = sasSeconds < 0.0;
                int minIntegralWidth = negative ? "-0:00:00".length() : "0:00:00".length();
                int actualPrecision = width > minIntegralWidth ? Math.min(width - minIntegralWidth, precision) : 0;
                BigDecimal[] parts = this.roundSeconds((double)sasSeconds, width, actualPrecision, minIntegralWidth);
                String hh = String.valueOf(parts[0].longValue());
                if (negative) {
                    hh = "-" + hh;
                }
                if (hh.length() > width) {
                    return SasTemporalUtils.nChars('*', width);
                }
                if (hh.length() > width - 3) {
                    return hh;
                }
                parts = parts[1].divideAndRemainder(SasTemporalConstants.BIG_MINUTES_IN_HOUR);
                String mm = String.valueOf(parts[0].longValue());
                String hhmm = hh + (mm.length() > 1 ? ":" : ":0") + mm;
                if (hhmm.length() > width - 3) {
                    return hhmm;
                }
                String ss = parts[1].toString();
                return hhmm + (ss.length() > 1 && ss.charAt(1) != '.' ? ":" : ":0") + ss;
            };
        }
    }
    ,
    MMSS(5){

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return sasSeconds -> {
                boolean negative = sasSeconds < 0.0;
                BigDecimal[] parts = new BigDecimal((double)sasSeconds).abs().setScale(precision, RoundingMode.HALF_UP).divideAndRemainder(SasTemporalConstants.BIG_SECONDS_IN_MINUTE);
                String mm = String.valueOf(parts[0].longValue());
                if (negative) {
                    mm = "-" + mm;
                }
                if (mm.length() > width) {
                    return "**";
                }
                if (mm.length() > width - 3) {
                    return mm;
                }
                String ss = parts[1].toString();
                String mmss = mm + (ss.length() > 1 && ss.charAt(1) != '.' ? ":" : ":0") + ss;
                if (mmss.length() > width) {
                    return mmss.substring(0, width);
                }
                return mmss;
            };
        }
    }
    ,
    HHMM(5){

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return sasSeconds -> {
                boolean negative = sasSeconds < 0.0;
                BigDecimal[] parts = new BigDecimal((double)sasSeconds).abs().divide(SasTemporalConstants.BIG_SECONDS_IN_MINUTE, precision, 4).divideAndRemainder(SasTemporalConstants.BIG_MINUTES_IN_HOUR);
                String hh = String.valueOf(parts[0].longValue());
                if (negative) {
                    hh = "-" + hh;
                }
                if (hh.length() > width) {
                    return "**";
                }
                if (hh.length() > width - 3) {
                    return hh;
                }
                String mm = parts[1].toString();
                String hhmm = hh + (mm.length() > 1 && mm.charAt(1) != '.' ? ":" : ":0") + mm;
                if (hhmm.length() > width) {
                    return hhmm.substring(0, width);
                }
                return hhmm;
            };
        }
    }
    ,
    HOUR(2){

        private BigDecimal roundAdjustHours(double sasSeconds, int width, int precision) {
            BigDecimal bigSeconds = BigDecimal.valueOf(sasSeconds / 3600.0).abs();
            BigDecimal hours = bigSeconds.setScale(precision, RoundingMode.HALF_UP);
            int adjustedPrecision = precision;
            while (adjustedPrecision > 0 && hours.toString().length() > width && (hours.longValue() != 0L || width - precision != 1)) {
                hours = bigSeconds.setScale(--adjustedPrecision, RoundingMode.HALF_UP);
            }
            return hours;
        }

        private String eNotation(BigDecimal hours, int width) {
            int i = 0;
            String hh = null;
            while (true) {
                DecimalFormat decimalFormat = i == 0 ? new DecimalFormat("0E0") : new DecimalFormat("#" + SasTemporalUtils.nChars('0', i) + "E0");
                ++i;
                String tmp = decimalFormat.format(hours);
                if (tmp.length() > width) break;
                hh = tmp;
            }
            return hh;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return sasSeconds -> {
                BigDecimal hours = this.roundAdjustHours((double)sasSeconds, width, precision);
                if (precision > 0 && hours.longValue() == 0L && width - precision == 1) {
                    return hours.toString().substring(1);
                }
                String hh = hours.toString();
                if (width > 2 && hh.length() > width) {
                    hh = this.eNotation(hours, width);
                }
                if (hh == null || hh.length() > width) {
                    return "**";
                }
                return hh;
            };
        }
    }
    ,
    TIMEAMPM(11){

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    E8601LZ(0){

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    E8601TM(8){

        @Override
        public int getActualPrecision(int width, int precision) {
            return width > this.getDefaultWidth() ? Math.min(width - this.getDefaultWidth(), precision) : 0;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return sasSeconds -> {
                String hh;
                if (sasSeconds < 0.0 || sasSeconds > 86400.0) {
                    return SasTemporalUtils.nChars('*', width);
                }
                BigDecimal daySeconds = SasTemporalUtils.roundSeconds(sasSeconds, precision).remainder(SasTemporalConstants.BIG_SECONDS_IN_DAY);
                BigDecimal[] parts = daySeconds.divideAndRemainder(SasTemporalConstants.BIG_SECONDS_IN_HOUR);
                int adjustedPrecision = precision;
                int firstTwoDigitsNumberAfterSingleDigit = 10;
                if (parts[0].longValue() >= (long)firstTwoDigitsNumberAfterSingleDigit && precision > 0 && width - precision == 8) {
                    adjustedPrecision = precision - 1;
                    daySeconds = SasTemporalUtils.roundSeconds(sasSeconds, adjustedPrecision).remainder(SasTemporalConstants.BIG_SECONDS_IN_DAY);
                    parts = daySeconds.divideAndRemainder(SasTemporalConstants.BIG_SECONDS_IN_HOUR);
                }
                if ((hh = String.valueOf(parts[0].longValue())).length() == 1 && width != 4 && width != 7 && (adjustedPrecision <= 0 || width - 8 != adjustedPrecision)) {
                    hh = '0' + hh;
                }
                parts = parts[1].divideAndRemainder(SasTemporalConstants.BIG_SECONDS_IN_MINUTE);
                String mm = String.valueOf(parts[0].longValue());
                String hhmm = hh + (mm.length() == 1 ? ":0" : ":") + mm;
                String ss = String.valueOf(parts[1].longValue());
                String hhmmss = hhmm + (ss.length() == 1 ? ":0" : ":") + ss;
                if (adjustedPrecision == 0 || hhmmss.length() > width - adjustedPrecision) {
                    return hhmmss;
                }
                adjustedPrecision = Math.min(adjustedPrecision, width - hhmmss.length());
                String nanos = parts[1].remainder(BigDecimal.ONE).toString().substring(1, adjustedPrecision + 2);
                return hhmmss + nanos;
            };
        }
    };

    private static final Logger LOGGER;
    private final int defaultWidth;

    private SasTimeFormat(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    @Override
    public final int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public int getActualPrecision(int width, int precision) {
        return precision;
    }

    @Override
    public final Function<Double, String> getFallbackFormatFunction(int width, int precision) {
        LOGGER.warn("Note that {}{}.{} format is not yet supported, using TIME. instead.", new Object[]{this.name(), width > 0 ? Integer.valueOf(width) : "", precision > 0 ? Integer.valueOf(precision) : ""});
        return TIME.getInternalFormatFunction(8, 0);
    }

    static {
        LOGGER = LoggerFactory.getLogger(SasTimeFormat.class);
    }
}

