/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class FilterFunction {
    public static final String name = "filter";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter function requires 2 paramaters, " + params.length + " found.");
        }
        if (!(params[1] instanceof BooleanValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filter function requires the second paramater to be single-valued and boolean.");
        }
        AnalyticsValueStream baseExpr = params[0];
        BooleanValue filterExpr = (BooleanValue)params[1];
        if (baseExpr instanceof DateValue) {
            return new DateFilterFunction((DateValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof DateValueStream) {
            return new DateStreamFilterFunction((DateValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof BooleanValue) {
            return new BooleanFilterFunction((BooleanValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof BooleanValueStream) {
            return new BooleanStreamFilterFunction((BooleanValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof IntValue) {
            return new IntFilterFunction((IntValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof IntValueStream) {
            return new IntStreamFilterFunction((IntValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof LongValue) {
            return new LongFilterFunction((LongValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof LongValueStream) {
            return new LongStreamFilterFunction((LongValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof FloatValue) {
            return new FloatFilterFunction((FloatValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof FloatValueStream) {
            return new FloatStreamFilterFunction((FloatValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof DoubleValue) {
            return new DoubleFilterFunction((DoubleValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof DoubleValueStream) {
            return new DoubleStreamFilterFunction((DoubleValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof StringValue) {
            return new StringFilterFunction((StringValue)baseExpr, filterExpr);
        }
        if (baseExpr instanceof StringValueStream) {
            return new StringStreamFilterFunction((StringValueStream)baseExpr, filterExpr);
        }
        if (baseExpr instanceof AnalyticsValue) {
            return new ValueFilterFunction((AnalyticsValue)baseExpr, filterExpr);
        }
        return new StreamFilterFunction(baseExpr, filterExpr);
    };

    static class StringFilterFunction
    extends StringValue.AbstractStringValue {
        private final StringValue baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public StringFilterFunction(StringValue baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public String getString() {
            String value = this.baseExpr.getString();
            this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringStreamFilterFunction
    extends StringValueStream.AbstractStringValueStream {
        private final StringValueStream baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StringStreamFilterFunction(StringValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
                this.baseExpr.streamStrings(cons);
            }
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateFilterFunction
    extends DateValue.AbstractDateValue {
        private final DateValue baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public DateFilterFunction(DateValue baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public long getLong() {
            long value = this.baseExpr.getLong();
            this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateStreamFilterFunction
    extends DateValueStream.AbstractDateValueStream {
        private final DateValueStream baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DateStreamFilterFunction(DateValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
                this.baseExpr.streamLongs(cons);
            }
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleFilterFunction
    extends DoubleValue.AbstractDoubleValue {
        private final DoubleValue baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public DoubleFilterFunction(DoubleValue baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public double getDouble() {
            double value = this.baseExpr.getDouble();
            this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleStreamFilterFunction
    extends DoubleValueStream.AbstractDoubleValueStream {
        private final DoubleValueStream baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DoubleStreamFilterFunction(DoubleValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
                this.baseExpr.streamDoubles(cons);
            }
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatFilterFunction
    extends FloatValue.AbstractFloatValue {
        private final FloatValue baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public FloatFilterFunction(FloatValue baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public float getFloat() {
            float value = this.baseExpr.getFloat();
            this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatStreamFilterFunction
    extends FloatValueStream.AbstractFloatValueStream {
        private final FloatValueStream baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public FloatStreamFilterFunction(FloatValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
                this.baseExpr.streamFloats(cons);
            }
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongFilterFunction
    extends LongValue.AbstractLongValue {
        private final LongValue baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public LongFilterFunction(LongValue baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public long getLong() {
            long value = this.baseExpr.getLong();
            this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamFilterFunction
    extends LongValueStream.AbstractLongValueStream {
        private final LongValueStream baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongStreamFilterFunction(LongValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
                this.baseExpr.streamLongs(cons);
            }
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntFilterFunction
    extends IntValue.AbstractIntValue {
        private final IntValue baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public IntFilterFunction(IntValue baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public int getInt() {
            int value = this.baseExpr.getInt();
            this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntStreamFilterFunction
    extends IntValueStream.AbstractIntValueStream {
        private final IntValueStream baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public IntStreamFilterFunction(IntValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
                this.baseExpr.streamInts(cons);
            }
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanFilterFunction
    extends BooleanValue.AbstractBooleanValue {
        private final BooleanValue baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public BooleanFilterFunction(BooleanValue baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public boolean getBoolean() {
            boolean value = this.baseExpr.getBoolean();
            this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamFilterFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final BooleanValueStream baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public BooleanStreamFilterFunction(BooleanValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
                this.baseExpr.streamBooleans(cons);
            }
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ValueFilterFunction
    extends AnalyticsValue.AbstractAnalyticsValue {
        private final AnalyticsValue baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public ValueFilterFunction(AnalyticsValue baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public Object getObject() {
            Object value = this.baseExpr.getObject();
            this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StreamFilterFunction
    extends AnalyticsValueStream.AbstractAnalyticsValueStream {
        private final AnalyticsValueStream baseExpr;
        private final BooleanValue filterExpr;
        public static final String name = "filter";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StreamFilterFunction(AnalyticsValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.filterExpr = filterExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("filter", baseExpr, filterExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
                this.baseExpr.streamObjects(cons);
            }
        }

        @Override
        public String getName() {
            return "filter";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

