/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.scripting.xslt;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.solr.common.EmptyEntityResolver;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.handler.loader.XMLLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.scripting.xslt.TransformerProvider;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XSLTUpdateRequestHandler
extends UpdateRequestHandler {
    public void init(NamedList<?> args) {
        super.init(args);
        this.setAssumeContentType("application/xml");
        SolrParams p = null;
        if (args != null) {
            p = args.toSolrParams();
        }
        XsltXMLLoader loader = new XsltXMLLoader().init(p);
        this.loaders = Map.of("application/xml", loader, "text/xml", loader);
    }

    public String getDescription() {
        return "Add documents with XML, transforming with XSLT first";
    }

    @VisibleForTesting
    static class XsltXMLLoader
    extends XMLLoader {
        int xsltCacheLifetimeSeconds;

        XsltXMLLoader() {
        }

        public XsltXMLLoader init(SolrParams args) {
            super.init(args);
            this.xsltCacheLifetimeSeconds = 60;
            if (args != null) {
                this.xsltCacheLifetimeSeconds = args.getInt("xsltCacheLifetimeSeconds", 60);
            }
            return this;
        }

        public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
            String tr = req.getParams().get("tr", null);
            if (tr == null) {
                super.load(req, rsp, stream, processor);
                return;
            }
            if (!req.getCore().getCoreDescriptor().isConfigSetTrusted()) {
                throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "The configset for this collection was uploaded without any authentication in place, and this operation is not available for collections with untrusted configsets. To use this feature, re-upload the configset after enabling authentication and authorization.");
            }
            Transformer t = TransformerProvider.getTransformer(req, tr, this.xsltCacheLifetimeSeconds);
            DOMResult result = new DOMResult();
            try (InputStream is = stream.getStream();){
                XMLReader xmlr = this.saxFactory.newSAXParser().getXMLReader();
                xmlr.setErrorHandler((ErrorHandler)xmllog);
                xmlr.setEntityResolver(EmptyEntityResolver.SAX_INSTANCE);
                InputSource isrc = new InputSource(is);
                isrc.setEncoding(ContentStreamBase.getCharsetFromContentType((String)stream.getContentType()));
                SAXSource source = new SAXSource(xmlr, isrc);
                t.transform(source, result);
            }
            catch (TransformerException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.toString(), (Throwable)e);
            }
            try (XMLStreamReader parser = null;){
                parser = this.inputFactory.createXMLStreamReader(new DOMSource(result.getNode()));
                this.processUpdate(req, processor, parser);
            }
        }
    }
}

