/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.scripting.xslt;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.scripting.xslt.TransformerProvider;

public class XSLTResponseWriter
implements QueryResponseWriter {
    public static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private Integer xsltCacheLifetimeSeconds = null;

    public void init(NamedList<?> n) {
        SolrParams p = n.toSolrParams();
        this.xsltCacheLifetimeSeconds = p.getInt("xsltCacheLifetimeSeconds", 60);
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        Transformer t = null;
        try {
            t = this.getTransformer(request);
        }
        catch (Exception e) {
            throw new RuntimeException("getTransformer fails in getContentType", e);
        }
        Object mediaType = t.getOutputProperty("media-type");
        if (mediaType == null || ((String)mediaType).length() == 0) {
            mediaType = DEFAULT_CONTENT_TYPE;
        }
        if (!((String)mediaType).contains("charset")) {
            String encoding = t.getOutputProperty("encoding");
            if (encoding == null || encoding.length() == 0) {
                encoding = "UTF-8";
            }
            mediaType = (String)mediaType + "; charset=" + encoding;
        }
        return mediaType;
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        Transformer t = this.getTransformer(request);
        CharArrayWriter w = new CharArrayWriter();
        XMLWriter.writeResponse((Writer)w, (SolrQueryRequest)request, (SolrQueryResponse)response);
        BufferedReader r = new BufferedReader(new CharArrayReader(w.toCharArray()));
        StreamSource source = new StreamSource(r);
        StreamResult result = new StreamResult(writer);
        try {
            t.transform(source, result);
        }
        catch (TransformerException te) {
            throw new IOException("XSLT transformation error", te);
        }
    }

    protected Transformer getTransformer(SolrQueryRequest request) throws IOException {
        String xslt = request.getParams().required().get("tr");
        return TransformerProvider.getTransformer(request, xslt, this.xsltCacheLifetimeSeconds);
    }
}

