/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import org.apache.solr.common.util.ExecutorUtil;

public class OrderedExecutor<T>
implements Executor {
    private final ExecutorService delegate;
    private final SparseStripedLock<T> sparseStripedLock;

    public OrderedExecutor(int numThreads, ExecutorService delegate) {
        this.delegate = delegate;
        this.sparseStripedLock = new SparseStripedLock(numThreads);
    }

    @Override
    public void execute(Runnable runnable) {
        this.execute(null, runnable);
    }

    public void execute(T lockId, Runnable command) {
        try {
            this.sparseStripedLock.add(lockId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            if (ExecutorUtil.isShutdown((ExecutorService)this.delegate)) {
                throw new RejectedExecutionException();
            }
            this.delegate.execute(() -> {
                try {
                    command.run();
                }
                finally {
                    this.sparseStripedLock.remove(lockId);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.sparseStripedLock.remove(lockId);
            throw e;
        }
    }

    public void shutdownAndAwaitTermination() {
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.delegate);
    }

    private static class SparseStripedLock<T> {
        private ConcurrentHashMap<T, CountDownLatch> map = new ConcurrentHashMap();
        private final Semaphore sizeSemaphore;

        SparseStripedLock(int maxSize) {
            this.sizeSemaphore = new Semaphore(maxSize);
        }

        public void add(T t) throws InterruptedException {
            if (t != null) {
                CountDownLatch myLock = new CountDownLatch(1);
                CountDownLatch existingLock = this.map.putIfAbsent(t, myLock);
                while (existingLock != null) {
                    existingLock.await();
                    existingLock = this.map.putIfAbsent(t, myLock);
                }
            }
            try {
                this.sizeSemaphore.acquire();
            }
            catch (InterruptedException e) {
                if (t != null) {
                    this.map.remove(t).countDown();
                }
                throw e;
            }
        }

        public void remove(T t) {
            if (t != null) {
                this.map.remove(t).countDown();
            }
            this.sizeSemaphore.release();
        }
    }
}

