/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.carrotsearch.hppc.IntObjectHashMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.IOFunction;

public class UpdateLocks {
    private final long docLockTimeoutMs;
    private final ReadWriteLock blockUpdatesLock = new ReentrantReadWriteLock(true);
    private final IntObjectHashMap<LockAndCondition> hashToLock = new IntObjectHashMap<LockAndCondition>(32){

        protected int hashKey(int key) {
            return key;
        }
    };
    private final ArrayDeque<LockAndCondition> lockPool = new ArrayDeque(16);

    public UpdateLocks(long docLockTimeoutMs) {
        this.docLockTimeoutMs = docLockTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R runWithLock(BytesRef id, IOFunction<Condition, R> function) throws IOException {
        long startTimeNanos = System.nanoTime();
        this.lockForUpdate();
        try {
            IntObjectHashMap<LockAndCondition> intObjectHashMap;
            LockAndCondition lock;
            int hash = id.hashCode();
            Object object = this.hashToLock;
            synchronized (object) {
                int idx = this.hashToLock.indexOf(hash);
                if (this.hashToLock.indexExists(idx)) {
                    lock = (LockAndCondition)this.hashToLock.indexGet(idx);
                    assert (lock.refCount >= 1);
                    ++lock.refCount;
                } else {
                    lock = this.borrowLock();
                    this.hashToLock.indexInsert(idx, hash, (Object)lock);
                }
            }
            try {
                object = this.runWithLockInternal(id, function, lock, startTimeNanos);
                intObjectHashMap = this.hashToLock;
            }
            catch (Throwable throwable) {
                IntObjectHashMap<LockAndCondition> intObjectHashMap2 = this.hashToLock;
                synchronized (intObjectHashMap2) {
                    assert (lock.refCount > 0);
                    if (--lock.refCount == 0) {
                        this.hashToLock.remove(hash);
                        this.returnLock(lock);
                    }
                }
                throw throwable;
            }
            synchronized (intObjectHashMap) {
                assert (lock.refCount > 0);
                if (--lock.refCount == 0) {
                    this.hashToLock.remove(hash);
                    this.returnLock(lock);
                }
            }
            return (R)object;
        }
        finally {
            this.unlockForUpdate();
        }
    }

    private LockAndCondition borrowLock() {
        assert (Thread.holdsLock(this.hashToLock));
        if (this.lockPool.isEmpty()) {
            return new LockAndCondition();
        }
        return this.lockPool.removeLast();
    }

    private void returnLock(LockAndCondition lock) {
        assert (Thread.holdsLock(this.hashToLock));
        if (this.lockPool.size() < 16) {
            this.lockPool.add(lock);
            lock.refCount = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R runWithLockInternal(BytesRef id, IOFunction<Condition, R> function, LockAndCondition lock, long startTimeNanos) throws IOException {
        try {
            if (this.docLockTimeoutMs == 0L) {
                lock.lock.lockInterruptibly();
            } else {
                boolean timedOut;
                long remainingNs = TimeUnit.MILLISECONDS.toNanos(this.docLockTimeoutMs) - (System.nanoTime() - startTimeNanos);
                boolean bl = timedOut = !lock.lock.tryLock(remainingNs, TimeUnit.NANOSECONDS);
                if (timedOut) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to lock doc " + String.valueOf(id) + " in " + this.docLockTimeoutMs + " ms");
                }
            }
        }
        catch (InterruptedException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to lock doc " + String.valueOf(id), (Throwable)e);
        }
        try {
            R r = function.apply(lock.condition);
            return r;
        }
        finally {
            lock.lock.unlock();
        }
    }

    public void lockForUpdate() {
        this.blockUpdatesLock.readLock().lock();
    }

    public void unlockForUpdate() {
        this.blockUpdatesLock.readLock().unlock();
    }

    public void blockUpdates() {
        this.blockUpdatesLock.writeLock().lock();
    }

    public void unblockUpdates() {
        this.blockUpdatesLock.writeLock().unlock();
    }

    private static class LockAndCondition {
        final Lock lock = new ReentrantLock(true);
        final Condition condition = this.lock.newCondition();
        int refCount = 1;

        LockAndCondition() {
        }
    }
}

