/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.ConstNumberSource;
import org.apache.lucene.queries.function.valuesource.DoubleConstValueSource;
import org.apache.lucene.queries.function.valuesource.MultiValueSource;
import org.apache.lucene.queries.function.valuesource.VectorValueSource;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.function.FieldNameValueSource;
import org.apache.solr.search.function.distance.HaversineConstFunction;
import org.apache.solr.search.function.distance.HaversineFunction;
import org.apache.solr.util.DistanceUnits;
import org.apache.solr.util.SpatialUtils;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;

public class GeoDistValueSourceParser
extends ValueSourceParser {
    @Override
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        SpatialStrategyMultiValueSource spatialStrategyMultiValueSource;
        List<ValueSource> sources = this.transformFieldSources(fp, fp.parseValueSourceList(5));
        MultiValueSource mv1 = null;
        MultiValueSource mv2 = null;
        if (sources.size() != 0) {
            ValueSource vs1;
            if (sources.size() == 1) {
                ValueSource vs = sources.get(0);
                if (!(vs instanceof MultiValueSource)) {
                    throw new SyntaxError("geodist - invalid parameters:" + String.valueOf(sources));
                }
                mv1 = (MultiValueSource)vs;
            } else if (sources.size() == 2) {
                vs1 = sources.get(0);
                ValueSource vs2 = sources.get(1);
                if (vs1 instanceof MultiValueSource && vs2 instanceof MultiValueSource) {
                    mv1 = (MultiValueSource)vs1;
                    mv2 = (MultiValueSource)vs2;
                } else {
                    mv1 = this.makeMV(sources, sources);
                }
            } else if (sources.size() == 3) {
                vs1 = sources.get(0);
                if (vs1 instanceof MultiValueSource) {
                    mv1 = (MultiValueSource)vs1;
                    mv2 = this.makeMV(sources.subList(1, 3), sources);
                } else {
                    mv1 = this.makeMV(sources.subList(0, 2), sources);
                    vs1 = sources.get(2);
                    if (!(vs1 instanceof MultiValueSource)) {
                        throw new SyntaxError("geodist - invalid parameters:" + String.valueOf(sources));
                    }
                    mv2 = (MultiValueSource)vs1;
                }
            } else if (sources.size() == 4) {
                mv1 = this.makeMV(sources.subList(0, 2), sources);
                mv2 = this.makeMV(sources.subList(2, 4), sources);
            } else {
                throw new SyntaxError("geodist - invalid parameters:" + String.valueOf(sources));
            }
        }
        if (mv1 == null) {
            mv1 = this.parsePoint(fp);
            mv2 = this.parseSfield(fp);
        } else if (mv2 == null && (mv2 = this.parsePoint(fp)) == null) {
            mv2 = this.parseSfield(fp);
        }
        if (mv1 == null || mv2 == null) {
            throw new SyntaxError("geodist - not enough parameters:" + String.valueOf(sources));
        }
        double[] constants = this.getConstants(mv1);
        MultiValueSource other = mv2;
        if (constants == null) {
            constants = this.getConstants(mv2);
            other = mv1;
        }
        if ((spatialStrategyMultiValueSource = this.findSpatialStrategyMultiValueSource(mv1, mv2)) != null) {
            if (constants == null) {
                throw new SyntaxError("When using AbstractSpatialFieldType (e.g. RPT), the point must be supplied as constants");
            }
            SpatialStrategy strategy = spatialStrategyMultiValueSource.strategy;
            DistanceUnits distanceUnits = spatialStrategyMultiValueSource.distanceUnits;
            Point queryPoint = strategy.getSpatialContext().makePoint(constants[1], constants[0]);
            return ValueSource.fromDoubleValuesSource((DoubleValuesSource)strategy.makeDistanceValueSource(queryPoint, distanceUnits.multiplierFromDegreesToThisUnit()));
        }
        if (constants != null && other instanceof VectorValueSource) {
            return new HaversineConstFunction(constants[0], constants[1], (VectorValueSource)other);
        }
        return new HaversineFunction(mv1, mv2, 6371.0087714, true);
    }

    private List<ValueSource> transformFieldSources(FunctionQParser fp, List<ValueSource> sources) throws SyntaxError {
        ArrayList<ValueSource> result = new ArrayList<ValueSource>(sources.size());
        for (ValueSource valueSource : sources) {
            if (valueSource instanceof FieldNameValueSource) {
                String fieldName = ((FieldNameValueSource)valueSource).getFieldName();
                result.add((ValueSource)this.getMultiValueSource(fp, fieldName));
                continue;
            }
            result.add(valueSource);
        }
        return result;
    }

    private SpatialStrategyMultiValueSource findSpatialStrategyMultiValueSource(MultiValueSource mv1, MultiValueSource mv2) {
        if (mv1 instanceof SpatialStrategyMultiValueSource) {
            return (SpatialStrategyMultiValueSource)mv1;
        }
        if (mv2 instanceof SpatialStrategyMultiValueSource) {
            return (SpatialStrategyMultiValueSource)mv2;
        }
        return null;
    }

    private VectorValueSource makeMV(List<ValueSource> sources, List<ValueSource> orig) throws SyntaxError {
        ValueSource vs1 = sources.get(0);
        ValueSource vs2 = sources.get(1);
        if (vs1 instanceof MultiValueSource || vs2 instanceof MultiValueSource) {
            throw new SyntaxError("geodist - invalid parameters:" + String.valueOf(orig));
        }
        return new VectorValueSource(sources);
    }

    private MultiValueSource parsePoint(FunctionQParser fp) {
        String ptStr = fp.getParam("pt");
        if (ptStr == null) {
            return null;
        }
        Point point = SpatialUtils.parsePointSolrException(ptStr, SpatialContext.GEO);
        return new VectorValueSource(Arrays.asList(new DoubleConstValueSource(point.getY()), new DoubleConstValueSource(point.getX())));
    }

    private double[] getConstants(MultiValueSource vs) {
        if (vs instanceof SpatialStrategyMultiValueSource || !(vs instanceof VectorValueSource)) {
            return null;
        }
        List sources = ((VectorValueSource)vs).getSources();
        if (sources.get(0) instanceof ConstNumberSource && sources.get(1) instanceof ConstNumberSource) {
            return new double[]{((ConstNumberSource)sources.get(0)).getDouble(), ((ConstNumberSource)sources.get(1)).getDouble()};
        }
        return null;
    }

    private MultiValueSource parseSfield(FunctionQParser fp) throws SyntaxError {
        String sfield = fp.getParam("sfield");
        if (sfield == null) {
            return null;
        }
        return this.getMultiValueSource(fp, sfield);
    }

    private MultiValueSource getMultiValueSource(FunctionQParser fp, String sfield) throws SyntaxError {
        SchemaField sf = fp.getReq().getSchema().getField(sfield);
        FieldType type = sf.getType();
        if (type instanceof AbstractSpatialFieldType) {
            AbstractSpatialFieldType asft = (AbstractSpatialFieldType)type;
            return new SpatialStrategyMultiValueSource((SpatialStrategy)asft.getStrategy(sfield), asft.getDistanceUnits());
        }
        ValueSource vs = type.getValueSource(sf, fp);
        if (vs instanceof MultiValueSource) {
            return (MultiValueSource)vs;
        }
        throw new SyntaxError("Spatial field must implement MultiValueSource or extend AbstractSpatialFieldType:" + String.valueOf(sf));
    }

    private static class SpatialStrategyMultiValueSource
    extends VectorValueSource {
        final SpatialStrategy strategy;
        final DistanceUnits distanceUnits;

        public SpatialStrategyMultiValueSource(SpatialStrategy strategy, DistanceUnits distanceUnits) {
            super(Collections.emptyList());
            this.strategy = strategy;
            this.distanceUnits = distanceUnits;
        }

        public List<ValueSource> getSources() {
            throw new IllegalStateException();
        }
    }
}

