/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SweepCountAware;
import org.apache.solr.search.facet.SweepDISI;

final class UnionDISI
extends SweepDISI {
    final int maxIdx;
    private final SubIterStruct baseSub;
    private boolean collectBase;
    private final PriorityQueue<SubIterStruct> queue;
    private SubIterStruct top;
    private int docId = -1;

    UnionDISI(DocIdSetIterator[] subIterators, SlotAcc.CountSlotAcc[] countAccs, int size, int baseIdx) throws IOException {
        super(size, countAccs);
        this.maxIdx = size - 1;
        this.queue = new PriorityQueue<SubIterStruct>(size){

            protected boolean lessThan(SubIterStruct a, SubIterStruct b) {
                return a.docId < b.docId;
            }
        };
        int i = this.maxIdx;
        SubIterStruct tmpBaseSub = null;
        do {
            SubIterStruct subIterStruct = new SubIterStruct(subIterators[i], i);
            this.queue.add((Object)subIterStruct);
            if (i != baseIdx) continue;
            tmpBaseSub = subIterStruct;
        } while (i-- > 0);
        this.baseSub = tmpBaseSub;
        this.top = (SubIterStruct)this.queue.top();
    }

    public int nextDoc() throws IOException {
        if (this.top.docId == this.docId) {
            do {
                this.top.nextDoc();
                this.top = (SubIterStruct)this.queue.updateTop();
            } while (this.top.docId == this.docId);
        }
        if (this.baseSub != null) {
            this.collectBase = false;
        }
        this.docId = this.top.docId;
        return this.docId;
    }

    @Override
    public boolean collectBase() {
        assert (this.top.docId != this.docId) : "must call registerCounts() before collectBase()";
        return this.collectBase;
    }

    @Override
    public int registerCounts(SweepCountAware.SegCounter segCounter) throws IOException {
        int i = -1;
        do {
            if (!this.collectBase && this.top == this.baseSub) {
                this.collectBase = true;
            }
            segCounter.map(this.top.index, ++i);
            this.top.nextDoc();
            this.top = (SubIterStruct)this.queue.updateTop();
        } while (this.top.docId == this.docId);
        return i;
    }

    private static final class SubIterStruct {
        private final DocIdSetIterator sub;
        private final int index;
        private int docId;

        public SubIterStruct(DocIdSetIterator sub, int index) throws IOException {
            this.sub = sub;
            this.index = index;
            this.nextDoc();
        }

        public void nextDoc() throws IOException {
            this.docId = this.sub.nextDoc();
        }
    }
}

