/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.lucene.search.FieldDoc;
import org.apache.solr.common.util.NamedList;

public class ShardDoc
extends FieldDoc {
    public String shard;
    public String shardAddress;
    public int orderInShard;
    public Object id;
    public NamedList<List<Object>> sortFieldValues;
    public int positionInResponse;
    public Map<String, Object> scoreDependentFields = Collections.emptyMap();

    public ShardDoc(float score, Object[] fields, Object uniqueId, String shard) {
        super(-1, score, fields);
        this.id = uniqueId;
        this.shard = shard;
    }

    public ShardDoc() {
        super(-1, Float.NaN);
    }

    public void consumeScoreDependentFields(boolean returnRawScore, BiConsumer<String, Object> consumer) {
        if (returnRawScore) {
            consumer.accept("score", Float.valueOf(this.score));
        }
        if (!this.scoreDependentFields.isEmpty()) {
            this.scoreDependentFields.forEach(consumer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShardDoc)) {
            return false;
        }
        ShardDoc shardDoc = (ShardDoc)((Object)o);
        return Objects.equals(this.id, shardDoc.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "id=" + String.valueOf(this.id) + " ,score=" + this.score + " ,shard=" + this.shard + " ,orderInShard=" + this.orderInShard + " ,positionInResponse=" + this.positionInResponse + " ,sortFieldValues=" + String.valueOf(this.sortFieldValues);
    }
}

