/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.NotThreadSafe;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.routing.NoOpReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.component.CloudReplicaSource;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ReplicaSource;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.handler.component.StandaloneReplicaSource;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AllowListUrlChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpShardHandler
extends ShardHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ONLY_NRT_REPLICAS = "distribOnlyRealtime";
    private static final ShardResponse CANCELLATION_NOTIFICATION = new ShardResponse();
    private final HttpShardHandlerFactory httpShardHandlerFactory;
    protected final ConcurrentMap<ShardResponse, CompletableFuture<LBSolrClient.Rsp>> responseFutureMap;
    protected final BlockingQueue<ShardResponse> responses;
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private final Map<String, List<String>> shardToURLs;
    protected LBHttp2SolrClient lbClient;

    public HttpShardHandler(HttpShardHandlerFactory httpShardHandlerFactory) {
        this.httpShardHandlerFactory = httpShardHandlerFactory;
        this.lbClient = httpShardHandlerFactory.loadbalancer;
        this.responses = new LinkedBlockingQueue<ShardResponse>();
        this.responseFutureMap = new ConcurrentHashMap<ShardResponse, CompletableFuture<LBSolrClient.Rsp>>();
        this.shardToURLs = new HashMap<String, List<String>>();
    }

    public static boolean getShardsTolerantAsBool(SolrQueryRequest req) {
        String shardsTolerantValue = req.getParams().get("shards.tolerant");
        if (null == shardsTolerantValue || shardsTolerantValue.trim().equals("requireZkConnected")) {
            return false;
        }
        boolean tolerant = StrUtils.parseBool((String)shardsTolerantValue.trim());
        if (tolerant && SolrQueryRequest.disallowPartialResults(req.getParams())) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Use of shards.tolerant requires that partialResults is true. If partialResults is defaulted to false explicitly passing partialResults=true in the request will allow shards.tolerant to work");
        }
        return tolerant;
    }

    private List<String> getURLs(String shard) {
        List<String> urls = this.shardToURLs.get(shard);
        if (urls == null) {
            urls = this.httpShardHandlerFactory.buildURLList(shard);
            this.shardToURLs.put(shard, urls);
        }
        return urls;
    }

    private LBSolrClient.Req prepareLBRequest(ShardRequest sreq, String shard, ModifiableSolrParams params, List<String> urls) {
        params.remove("wt");
        params.remove("version");
        QueryRequest req = this.createQueryRequest(sreq, params, shard);
        req.setMethod(SolrRequest.METHOD.POST);
        SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
        if (requestInfo != null) {
            req.setUserPrincipal(requestInfo.getReq().getUserPrincipal());
        }
        return this.httpShardHandlerFactory.newLBHttpSolrClientReq(req, urls);
    }

    private ShardResponse prepareShardResponse(ShardRequest sreq, String shard) {
        ShardResponse srsp = new ShardResponse();
        if (sreq.nodeName != null) {
            srsp.setNodeName(sreq.nodeName);
        }
        srsp.setShardRequest(sreq);
        srsp.setShard(shard);
        return srsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordShardSubmitError(ShardResponse srsp, SolrException exception) {
        srsp.setException(exception);
        srsp.setResponseCode(exception.code());
        AtomicBoolean atomicBoolean = this.canceled;
        synchronized (atomicBoolean) {
            if (!this.canceled.get()) {
                this.responses.add(srsp);
            }
        }
    }

    @Override
    public void submit(ShardRequest sreq, String shard, ModifiableSolrParams params) {
        this.canceled.set(false);
        List<String> urls = this.getURLs(shard);
        LBSolrClient.Req lbReq = this.prepareLBRequest(sreq, shard, params, urls);
        ShardResponse srsp = this.prepareShardResponse(sreq, shard);
        SimpleSolrResponse ssr = new SimpleSolrResponse();
        srsp.setSolrResponse(ssr);
        if (urls.isEmpty()) {
            this.recordShardSubmitError(srsp, new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no servers hosting shard: " + shard));
            return;
        }
        long startTimeNS = System.nanoTime();
        this.makeShardRequest(sreq, shard, params, lbReq, ssr, srsp, startTimeNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeShardRequest(ShardRequest sreq, String shard, ModifiableSolrParams params, LBSolrClient.Req lbReq, SimpleSolrResponse ssr, ShardResponse srsp, long startTimeNS) {
        CompletableFuture future = this.lbClient.requestAsync(lbReq);
        AtomicBoolean atomicBoolean = this.canceled;
        synchronized (atomicBoolean) {
            if (this.canceled.get() && !future.isDone()) {
                future.cancel(true);
                return;
            }
            this.responseFutureMap.put(srsp, future);
        }
        future.whenComplete((rsp, throwable) -> {
            if (rsp != null) {
                ssr.nl = rsp.getResponse();
                srsp.setShardAddress(rsp.getServer());
            } else if (throwable != null) {
                srsp.setException((Throwable)throwable);
                if (throwable instanceof SolrException) {
                    srsp.setResponseCode(((SolrException)((Object)throwable)).code());
                }
            }
            ssr.elapsedTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeNS, TimeUnit.NANOSECONDS);
            AtomicBoolean atomicBoolean = this.canceled;
            synchronized (atomicBoolean) {
                if (this.responseFutureMap.containsKey(srsp)) {
                    this.responses.add(this.transformResponse(sreq, srsp, shard));
                }
            }
        });
    }

    protected QueryRequest createQueryRequest(ShardRequest sreq, ModifiableSolrParams params, String shard) {
        return new QueryRequest((SolrParams)params);
    }

    protected ShardResponse transformResponse(ShardRequest sreq, ShardResponse rsp, String shard) {
        return rsp;
    }

    @Override
    public ShardResponse takeCompletedIncludingErrors() {
        return this.take(false);
    }

    @Override
    public ShardResponse takeCompletedOrError() {
        return this.take(true);
    }

    private ShardResponse take(boolean bailOnError) {
        ShardResponse previousResponse = null;
        try {
            while (this.responsesPending()) {
                ShardResponse rsp = this.responses.take();
                if (rsp == CANCELLATION_NOTIFICATION) {
                    this.responses.clear();
                    if (previousResponse == null) {
                        return null;
                    }
                    return previousResponse.getShardRequest().responses.stream().filter(sr -> sr.getException() != null).findFirst().orElse(previousResponse);
                }
                this.responseFutureMap.remove(rsp);
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getException() != null && (bailOnError || SolrQueryRequest.disallowPartialResults((SolrParams)rsp.getShardRequest().params))) {
                    this.cancelAll();
                }
                if (rsp.getShardRequest().responses.size() == rsp.getShardRequest().actualShards.length) {
                    return rsp;
                }
                previousResponse = rsp;
            }
        }
        catch (InterruptedException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        return null;
    }

    protected boolean responsesPending() {
        return !this.responseFutureMap.isEmpty() || !this.responses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        AtomicBoolean atomicBoolean = this.canceled;
        synchronized (atomicBoolean) {
            boolean alreadyCanceled = this.canceled.getAndSet(true);
            if (!alreadyCanceled) {
                this.responses.add(CANCELLATION_NOTIFICATION);
            }
            for (CompletableFuture future : this.responseFutureMap.values()) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            this.responseFutureMap.clear();
        }
    }

    @Override
    public void prepDistributed(ResponseBuilder rb) {
        String shards_start;
        ReplicaSource replicaSource;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String shards = params.get("shards");
        CoreDescriptor coreDescriptor = req.getCore().getCoreDescriptor();
        CloudDescriptor cloudDescriptor = req.getCloudDescriptor();
        ZkController zkController = req.getCoreContainer().getZkController();
        ReplicaListTransformer replicaListTransformer = this.httpShardHandlerFactory.getReplicaListTransformer(req);
        AllowListUrlChecker urlChecker = req.getCoreContainer().getAllowListUrlChecker();
        if (shards != null && zkController == null && urlChecker.isEnabled() && !urlChecker.hasExplicitAllowList()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "solr.xml property 'allowUrls' not configured but required (in lieu of ZkController and ClusterState) when using the 'shards' parameter. Set -Dsolr.disable.allowUrls=true to disable URL allow-list checks.");
        }
        if (zkController != null) {
            boolean onlyNrt = Boolean.TRUE == req.getContext().get(ONLY_NRT_REPLICAS);
            replicaSource = new CloudReplicaSource.Builder().params(params).zkStateReader(zkController.getZkStateReader()).allowListUrlChecker(urlChecker).replicaListTransformer(replicaListTransformer).collection(cloudDescriptor.getCollectionName()).onlyNrt(onlyNrt).build();
            rb.slices = replicaSource.getSliceNames().toArray(new String[replicaSource.getSliceCount()]);
            if (this.canShortCircuit(rb.slices, onlyNrt, params, cloudDescriptor)) {
                rb.isDistrib = false;
                rb.shortCircuitedURL = ZkCoreNodeProps.getCoreUrl((String)zkController.getBaseUrl(), (String)coreDescriptor.getName());
                return;
            }
            if (!HttpShardHandler.getShardsTolerantAsBool(req)) {
                for (int i = 0; i < rb.slices.length; ++i) {
                    if (!replicaSource.getReplicasBySlice(i).isEmpty()) continue;
                    CloudReplicaSource allActiveReplicaSource = new CloudReplicaSource.Builder().params(params).zkStateReader(zkController.getZkStateReader()).allowListUrlChecker(AllowListUrlChecker.ALLOW_ALL).replicaListTransformer(NoOpReplicaListTransformer.INSTANCE).collection(cloudDescriptor.getCollectionName()).onlyNrt(false).build();
                    String adjective = allActiveReplicaSource.getReplicasBySlice(i).isEmpty() ? "active" : "eligible";
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no " + adjective + " servers hosting shard: " + rb.slices[i]);
                }
            }
        } else {
            replicaSource = new StandaloneReplicaSource.Builder().allowListUrlChecker(urlChecker).shards(shards).build();
            rb.slices = new String[replicaSource.getSliceCount()];
        }
        rb.shards = new String[rb.slices.length];
        for (int i = 0; i < rb.slices.length; ++i) {
            rb.shards[i] = HttpShardHandler.createSliceShardsStr(replicaSource.getReplicasBySlice(i));
        }
        String shards_rows = params.get("shards.rows");
        if (shards_rows != null) {
            rb.shards_rows = Integer.parseInt(shards_rows);
        }
        if ((shards_start = params.get("shards.start")) != null) {
            rb.shards_start = Integer.parseInt(shards_start);
        }
    }

    private static String createSliceShardsStr(List<String> shardUrls) {
        return String.join((CharSequence)"|", shardUrls);
    }

    private boolean canShortCircuit(String[] slices, boolean onlyNrtReplicas, SolrParams params, CloudDescriptor cloudDescriptor) {
        String ourSlice = cloudDescriptor.getShardId();
        String ourCollection = cloudDescriptor.getCollectionName();
        if (!(slices.length != 1 || slices[0] == null || !slices[0].equals(ourSlice) && !slices[0].equals(ourCollection + "_" + ourSlice) || cloudDescriptor.getLastPublished() != Replica.State.ACTIVE || onlyNrtReplicas && cloudDescriptor.getReplicaType() != Replica.Type.NRT)) {
            boolean shortCircuit = params.getBool("shortCircuit", true);
            String targetHandler = params.get("shards.qt");
            shortCircuit = shortCircuit && targetHandler == null;
            return shortCircuit;
        }
        return false;
    }

    @Override
    public ShardHandlerFactory getShardHandlerFactory() {
        return this.httpShardHandlerFactory;
    }

    public static class SimpleSolrResponse
    extends SolrResponse {
        volatile long elapsedTime;
        volatile NamedList<Object> nl;

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public NamedList<Object> getResponse() {
            return this.nl;
        }

        public void setResponse(NamedList<Object> rsp) {
            this.nl = rsp;
        }

        public void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }
    }
}

