/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Ticker;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CoreAdminOperation;
import org.apache.solr.handler.admin.api.AllCoresStatusAPI;
import org.apache.solr.handler.admin.api.CoreSnapshot;
import org.apache.solr.handler.admin.api.CreateCoreAPI;
import org.apache.solr.handler.admin.api.CreateCoreBackup;
import org.apache.solr.handler.admin.api.GetNodeCommandStatus;
import org.apache.solr.handler.admin.api.InstallCoreData;
import org.apache.solr.handler.admin.api.MergeIndexes;
import org.apache.solr.handler.admin.api.OverseerOperationAPI;
import org.apache.solr.handler.admin.api.PrepareCoreRecoveryAPI;
import org.apache.solr.handler.admin.api.RejoinLeaderElectionAPI;
import org.apache.solr.handler.admin.api.ReloadCore;
import org.apache.solr.handler.admin.api.RenameCore;
import org.apache.solr.handler.admin.api.RequestApplyCoreUpdatesAPI;
import org.apache.solr.handler.admin.api.RequestBufferUpdatesAPI;
import org.apache.solr.handler.admin.api.RequestCoreRecoveryAPI;
import org.apache.solr.handler.admin.api.RequestSyncShardAPI;
import org.apache.solr.handler.admin.api.RestoreCore;
import org.apache.solr.handler.admin.api.SingleCoreStatusAPI;
import org.apache.solr.handler.admin.api.SplitCoreAPI;
import org.apache.solr.handler.admin.api.SwapCores;
import org.apache.solr.handler.admin.api.UnloadCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.solr.util.tracing.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CoreAdminHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    protected final CoreAdminAsyncTracker coreAdminAsyncTracker;
    protected final Map<String, CoreAdminOp> opMap;
    public static String RESPONSE_STATUS = "STATUS";
    public static String RESPONSE_MESSAGE = "msg";
    public static String OPERATION_RESPONSE = "response";
    public static Map<String, String> paramToProp = Map.ofEntries(Map.entry("config", "config"), Map.entry("schema", "schema"), Map.entry("dataDir", "dataDir"), Map.entry("ulogDir", "ulogDir"), Map.entry("configSet", "configSet"), Map.entry("loadOnStartup", "loadOnStartup"), Map.entry("transient", "transient"), Map.entry("shard", "shard"), Map.entry("collection", "collection"), Map.entry("roles", "roles"), Map.entry("coreNodeName", "coreNodeName"), Map.entry("numShards", "numShards"), Map.entry("replicaType", "replicaType"));

    public CoreAdminHandler() {
        this.coreContainer = null;
        this.coreAdminAsyncTracker = new CoreAdminAsyncTracker();
        this.opMap = CoreAdminHandler.initializeOpMap();
    }

    public CoreAdminHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.coreAdminAsyncTracker = new CoreAdminAsyncTracker();
        this.opMap = CoreAdminHandler.initializeOpMap();
    }

    @Override
    public final void init(NamedList<?> args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        super.initializeMetrics(parentContext, scope);
        this.coreAdminAsyncTracker.standardExecutor = MetricUtils.instrumentedExecutorService(this.coreAdminAsyncTracker.standardExecutor, this, this.solrMetricsContext.getMetricRegistry(), SolrMetricManager.mkName("parallelCoreAdminExecutor", this.getCategory().name(), scope, "threadPool"));
        this.coreAdminAsyncTracker.expensiveExecutor = MetricUtils.instrumentedExecutorService(this.coreAdminAsyncTracker.expensiveExecutor, this, this.solrMetricsContext.getMetricRegistry(), SolrMetricManager.mkName("parallelCoreExpensiveAdminExecutor", this.getCategory().name(), scope, "threadPool"));
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    public final void registerCustomActions(Map<String, CoreAdminOp> customActions) {
        for (Map.Entry<String, CoreAdminOp> entry : customActions.entrySet()) {
            String action = entry.getKey().toLowerCase(Locale.ROOT);
            CoreAdminOp operation = entry.getValue();
            if (this.opMap.containsKey(action)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler already registered action " + action);
            }
            this.opMap.put(action, operation);
        }
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    public CoreAdminAsyncTracker getCoreAdminAsyncTracker() {
        return this.coreAdminAsyncTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        try {
            CoreContainer cores = this.getCoreContainer();
            if (cores == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
            }
            String taskId = req.getParams().get("async");
            String action = req.getParams().get("action", CoreAdminParams.CoreAdminAction.STATUS.toString()).toLowerCase(Locale.ROOT);
            CoreAdminOp op = this.opMap.get(action);
            if (op == null) {
                log.warn("action '{}' not found, calling custom action handler. If original intention was to target some custom behaviour use custom actions defined in 'solr.xml' instead", (Object)action);
                this.handleCustomAction(req, rsp);
                return;
            }
            CallInfo callInfo = new CallInfo(this, req, rsp, op);
            String coreName = req.getParams().get("core", req.getParams().get("name"));
            MDCLoggingContext.setCoreName(coreName);
            TraceUtils.setDbInstance(req, coreName);
            if (taskId == null) {
                callInfo.call();
            } else {
                Callable<SolrQueryResponse> task = () -> {
                    callInfo.call();
                    return callInfo.rsp;
                };
                CoreAdminAsyncTracker.TaskObject taskObject = new CoreAdminAsyncTracker.TaskObject(taskId, action, op.isExpensive(), task);
                this.coreAdminAsyncTracker.submitAsyncTask(taskObject);
            }
        }
        finally {
            rsp.setHttpCaching(false);
        }
    }

    @Deprecated
    protected void handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported operation: " + req.getParams().get("action"));
    }

    private static Map<String, CoreAdminOp> initializeOpMap() {
        HashMap<String, CoreAdminOp> opMap = new HashMap<String, CoreAdminOp>();
        for (CoreAdminOperation op : CoreAdminOperation.values()) {
            opMap.put(op.action.toString().toLowerCase(Locale.ROOT), op);
        }
        return opMap;
    }

    protected static Map<String, String> buildCoreParams(SolrParams params) {
        HashMap<String, String> coreParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : paramToProp.entrySet()) {
            String value = params.get(entry.getKey(), null);
            if (!StrUtils.isNotNullOrEmpty((String)value)) continue;
            coreParams.put(entry.getValue(), value);
        }
        Iterator paramsIt = params.getParameterNamesIterator();
        while (paramsIt.hasNext()) {
            String param = (String)paramsIt.next();
            if (param.startsWith("property.")) {
                String propName = param.substring("property.".length());
                String propValue = params.get(param);
                coreParams.put(propName, propValue);
            }
            if (!param.startsWith("collection.")) continue;
            coreParams.put(param, params.get(param));
        }
        return coreParams;
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String action = ctx.getParams().get("action");
        if (action == null) {
            return PermissionNameProvider.Name.CORE_READ_PERM;
        }
        CoreAdminParams.CoreAdminAction coreAction = CoreAdminParams.CoreAdminAction.get((String)action);
        if (coreAction == null) {
            return PermissionNameProvider.Name.CORE_READ_PERM;
        }
        return coreAction.isRead ? PermissionNameProvider.Name.CORE_READ_PERM : PermissionNameProvider.Name.CORE_EDIT_PERM;
    }

    public void shutdown() {
        this.coreAdminAsyncTracker.shutdown();
    }

    @Override
    public Collection<Api> getApis() {
        ArrayList<Api> apis = new ArrayList<Api>();
        apis.addAll(AnnotatedApi.getApis(new AllCoresStatusAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SingleCoreStatusAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new CreateCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RejoinLeaderElectionAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new OverseerOperationAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SplitCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestCoreRecoveryAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new PrepareCoreRecoveryAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestApplyCoreUpdatesAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestSyncShardAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestBufferUpdatesAPI(this)));
        return apis;
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(CoreSnapshot.class, InstallCoreData.class, CreateCoreBackup.class, RestoreCore.class, ReloadCore.class, UnloadCore.class, SwapCores.class, RenameCore.class, MergeIndexes.class, GetNodeCommandStatus.class);
    }

    public static class CoreAdminAsyncTracker {
        private static final int MAX_TRACKED_REQUESTS = EnvUtils.getPropertyAsInteger((String)"solr.admin.async.max", (Integer)10000);
        public static final String RUNNING = "running";
        public static final String COMPLETED = "completed";
        public static final String FAILED = "failed";
        private final Cache<String, TaskObject> requestStatusCache;
        private ExecutorService standardExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)50, (ThreadFactory)new SolrNamedThreadFactory("parallelCoreAdminAPIBaseExecutor"));
        private ExecutorService expensiveExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((int)5, (int)Integer.MAX_VALUE, (ThreadFactory)new SolrNamedThreadFactory("parallelCoreAdminAPIExpensiveExecutor"));

        public CoreAdminAsyncTracker() {
            this(Ticker.systemTicker(), TimeUnit.MINUTES.toNanos(EnvUtils.getPropertyAsLong((String)"solr.admin.async.timeout.minutes", (Long)60L)), TimeUnit.MINUTES.toNanos(EnvUtils.getPropertyAsLong((String)"solr.admin.async.timeout.completed.minutes", (Long)5L)));
        }

        CoreAdminAsyncTracker(Ticker ticker, long runningTimeoutNanos, long completedTimeoutNanos) {
            TaskExpiry expiry = new TaskExpiry(runningTimeoutNanos, completedTimeoutNanos);
            this.requestStatusCache = Caffeine.newBuilder().ticker(ticker).maximumSize((long)MAX_TRACKED_REQUESTS).expireAfter((Expiry)expiry).build();
        }

        public void shutdown() {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.standardExecutor);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.expensiveExecutor);
        }

        public TaskObject getAsyncRequestForStatus(String key) {
            TaskObject task = (TaskObject)this.requestStatusCache.getIfPresent((Object)key);
            if (task != null && !RUNNING.equals(task.status) && !task.polledAfterCompletion) {
                task.polledAfterCompletion = true;
                this.requestStatusCache.getIfPresent((Object)key);
            }
            return task;
        }

        public void submitAsyncTask(TaskObject taskObject) throws SolrException {
            this.addTask(taskObject);
            Runnable command = () -> {
                boolean exceptionCaught = false;
                try {
                    SolrQueryResponse response = taskObject.task.call();
                    taskObject.setRspObject(response);
                    taskObject.setOperationRspObject(response);
                    this.finishTask(taskObject, !exceptionCaught);
                }
                catch (Exception e) {
                    try {
                        exceptionCaught = true;
                        taskObject.setRspObjectFromException(e);
                        this.finishTask(taskObject, !exceptionCaught);
                    }
                    catch (Throwable throwable) {
                        this.finishTask(taskObject, !exceptionCaught);
                        throw throwable;
                    }
                }
            };
            try {
                MDC.put((String)"CoreAdminHandler.asyncId", (String)taskObject.taskId);
                MDC.put((String)"CoreAdminHandler.action", (String)taskObject.action);
                if (taskObject.expensive) {
                    this.expensiveExecutor.execute(command);
                } else {
                    this.standardExecutor.execute(command);
                }
            }
            finally {
                MDC.remove((String)"CoreAdminHandler.asyncId");
                MDC.remove((String)"CoreAdminHandler.action");
            }
        }

        private void addTask(TaskObject taskObject) {
            TaskObject taskInCache = (TaskObject)this.requestStatusCache.get((Object)taskObject.taskId, n -> {
                taskObject.status = RUNNING;
                return taskObject;
            });
            if (taskInCache != taskObject) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Duplicate request with the same requestid found.");
            }
        }

        private void finishTask(TaskObject taskObject, boolean successful) {
            taskObject.status = successful ? COMPLETED : FAILED;
        }

        private static class TaskExpiry
        implements Expiry<String, TaskObject> {
            private final long runningTimeoutNanos;
            private final long completedTimeoutNanos;

            private TaskExpiry(long runningTimeoutNanos, long completedTimeoutNanos) {
                this.runningTimeoutNanos = runningTimeoutNanos;
                this.completedTimeoutNanos = completedTimeoutNanos;
            }

            public long expireAfterCreate(String key, TaskObject task, long currentTime) {
                return this.runningTimeoutNanos;
            }

            public long expireAfterUpdate(String key, TaskObject task, long currentTime, long currentDuration) {
                return task.polledAfterCompletion ? this.completedTimeoutNanos : this.runningTimeoutNanos;
            }

            public long expireAfterRead(String key, TaskObject task, long currentTime, long currentDuration) {
                return task.polledAfterCompletion ? this.completedTimeoutNanos : this.runningTimeoutNanos;
            }
        }

        public static class TaskObject {
            final String taskId;
            final String action;
            final boolean expensive;
            final Callable<SolrQueryResponse> task;
            public String rspInfo;
            public Object operationRspInfo;
            private volatile String status;
            private volatile boolean polledAfterCompletion;

            public TaskObject(String taskId, String action, boolean expensive, Callable<SolrQueryResponse> task) {
                this.taskId = taskId;
                this.action = action;
                this.expensive = expensive;
                this.task = task;
            }

            public String getRspObject() {
                return this.rspInfo;
            }

            public void setRspObject(SolrQueryResponse rspObject) {
                this.rspInfo = rspObject.getToLogAsString("TaskId: " + this.taskId);
            }

            public void setRspObjectFromException(Exception e) {
                this.rspInfo = e.getMessage();
            }

            public Object getOperationRspObject() {
                return this.operationRspInfo;
            }

            public void setOperationRspObject(SolrQueryResponse rspObject) {
                this.operationRspInfo = rspObject.getResponse();
            }

            public String getStatus() {
                return this.status;
            }
        }
    }

    public static interface CoreAdminOp {
        default public boolean isExpensive() {
            return false;
        }

        public void execute(CallInfo var1) throws Exception;
    }

    public static class CallInfo {
        public final CoreAdminHandler handler;
        public final SolrQueryRequest req;
        public final SolrQueryResponse rsp;
        public final CoreAdminOp op;

        CallInfo(CoreAdminHandler handler, SolrQueryRequest req, SolrQueryResponse rsp, CoreAdminOp op) {
            this.handler = handler;
            this.req = req;
            this.rsp = rsp;
            this.op = op;
        }

        void call() throws Exception {
            this.op.execute(this);
        }
    }
}

