/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.Iterator;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.AsArraySerializerBase;
import tools.jackson.databind.ser.std.StdContainerSerializer;

@JacksonStdImpl
public class IteratorSerializer
extends AsArraySerializerBase<Iterator<?>> {
    public IteratorSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        super(Iterator.class, elemType, staticTyping, vts, null);
    }

    public IteratorSerializer(IteratorSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property) {
        super(src, vts, valueSerializer, unwrapSingle, property);
    }

    @Override
    protected StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IteratorSerializer(this, vts, this._elementSerializer, this._unwrapSingle, this._property);
    }

    public IteratorSerializer withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new IteratorSerializer(this, vts, elementSerializer, unwrapSingle, property);
    }

    @Override
    public boolean isEmpty(SerializationContext prov, Iterator<?> value) {
        return !value.hasNext();
    }

    @Override
    public boolean hasSingleElement(Iterator<?> value) {
        return false;
    }

    @Override
    public final void serialize(Iterator<?> value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        gen.writeStartArray(value);
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(Iterator<?> value, JsonGenerator g, SerializationContext provider) throws JacksonException {
        if (!value.hasNext()) {
            return;
        }
        ValueSerializer serializer = this._elementSerializer;
        if (serializer == null) {
            this._serializeDynamicContents(value, g, provider);
            return;
        }
        TypeSerializer typeSer = this._valueTypeSerializer;
        do {
            Object elem;
            if ((elem = value.next()) == null) {
                provider.defaultSerializeNullValue(g);
                continue;
            }
            if (typeSer == null) {
                serializer.serialize(elem, g, provider);
                continue;
            }
            serializer.serializeWithType(elem, g, provider, typeSer);
        } while (value.hasNext());
    }

    protected void _serializeDynamicContents(Iterator<?> value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        TypeSerializer typeSer = this._valueTypeSerializer;
        do {
            Object elem;
            if ((elem = value.next()) == null) {
                ctxt.defaultSerializeNullValue(g);
                continue;
            }
            Class<?> cc = elem.getClass();
            ValueSerializer<Object> serializer = this._dynamicValueSerializers.serializerFor(cc);
            if (serializer == null) {
                serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._elementType, cc)) : this._findAndAddDynamic(ctxt, cc);
            }
            if (typeSer == null) {
                serializer.serialize(elem, g, ctxt);
                continue;
            }
            serializer.serializeWithType(elem, g, ctxt, typeSer);
        } while (value.hasNext());
    }
}

