/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFJMSConnectionGroup;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleDataSource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFJMSConnection
extends Thread
implements Monitor {
    private String jmsConnectionId;
    private String instanceName;
    private String serviceName;
    private String userName;
    private OpaqueString password;
    private Properties extrAuthProp;
    private String connClass;
    private ArrayList<String> listenerAddresses;
    private static final int MAX_NUMBER_OF_TRIES = 5;
    private Connection conn;
    private T4CTTIoaqnfy oaqnfy;
    private volatile boolean needToBeClosed;
    private boolean safeToClose;
    private int numberOfRegistrations;
    private NTFJMSConnectionGroup connectionGroup;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    NTFJMSConnection(String jmsConnectionId, ArrayList<String> listenerAddresses, String instanceName, String serviceName, String userName, OpaqueString password, Properties _extrAuthProp, String connClass, int numberOfRegistrations) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, jmsConnectionId, listenerAddresses, instanceName, serviceName, userName, password, _extrAuthProp, connClass, numberOfRegistrations);
            }
            this.conn = null;
            this.oaqnfy = null;
            this.needToBeClosed = false;
            this.safeToClose = true;
            this.numberOfRegistrations = 0;
            this.connectionGroup = null;
            this.monitorLock = this.newDefaultLock();
            this.userName = userName;
            this.password = password;
            this.extrAuthProp = _extrAuthProp;
            this.serviceName = serviceName;
            this.jmsConnectionId = jmsConnectionId;
            this.listenerAddresses = listenerAddresses;
            this.instanceName = instanceName;
            this.connClass = connClass;
            this.numberOfRegistrations = numberOfRegistrations;
            if (!$assertionsDisabled && listenerAddresses == null) {
                AssertionError assertionError = new AssertionError((Object)"listenerAddresses is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && instanceName == null) {
                AssertionError assertionError = new AssertionError((Object)"instancename is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void run() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$0, this, new Object[0]);
            }
            boolean retry = false;
            boolean reConnect = false;
            int conAttempt = 0;
            int errorCode = 0;
            for (int cnt = 0; cnt < 2 && !this.needToBeClosed; ++cnt) {
                try {
                    if (cnt == 0 || reConnect) {
                        this.conn = this.getConnection(conAttempt);
                        this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.jmsConnectionId);
                    }
                    if (retry || !this.needToBeClosed) {
                        retry = false;
                        reConnect = false;
                        cnt = 0;
                    }
                    this.oaqnfy.doRPC();
                    continue;
                }
                catch (IOException eIo) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFJMSConnection - connectionId = " + this.jmsConnectionId + ", userName = " + this.userName + ", connClass = " + this.connClass + ", instnaceName =" + this.instanceName + ": ERROR: got Exception during thread execution" + eIo.getMessage());
                    }
                    this.needToBeClosed = true;
                    continue;
                }
                catch (Exception e2) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFJMSConnection - connectionId = " + this.jmsConnectionId + ", userName = " + this.userName + ", connClass = " + this.connClass + ", instnaceName =" + this.instanceName + ": ERROR: got Exception during thread execution" + e2.getMessage());
                    }
                    if (this.needToBeClosed) break;
                    if (retry) {
                        this.getConnectionGroup().raiseException();
                        break;
                    }
                    if (e2 instanceof SQLException) {
                        errorCode = ((SQLException)e2).getErrorCode();
                    }
                    if (errorCode == 17410) {
                        reConnect = true;
                        errorCode = 0;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {}
                    } else {
                        reConnect = false;
                    }
                    retry = true;
                }
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFJMSConnection -, connectionId = " + this.jmsConnectionId + ", userName = " + this.userName + ": end of run method. Thread will be closed.");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Connection getConnection(int n2) throws SQLException, InterruptedException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void noOfTries;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, n2);
            }
            Connection notificationConnection = null;
            OracleDataSource ods = new OracleDataSource();
            Properties props = new Properties();
            if (this.extrAuthProp != null) {
                props.putAll((Map<?, ?>)this.extrAuthProp);
            }
            if (this.userName != null) {
                ods.setUser(this.userName);
                ods.setPassword(this.password.get());
            }
            if (this.connClass != null) {
                props.put("oracle.jdbc.DRCPConnectionClass", this.connClass);
                props.put("oracle.jdbc.jmsNotification", "true");
                props.put("oracle.jdbc.ReadTimeout", (Object)0);
                props.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
            }
            ods.setConnectionProperties(props);
            while (notificationConnection == null && ++noOfTries < 5 && !this.needToBeClosed) {
                notificationConnection = this.tryListenerAddressesToGetConnection(ods);
                if (notificationConnection != null || noOfTries >= 5) continue;
                Thread.sleep((long)(noOfTries * 5000));
            }
            if (notificationConnection == null && !this.needToBeClosed) {
                SQLException sQLException = new SQLException("Failed to create notification connection to emon server");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            Connection connection = notificationConnection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, connection);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Connection tryListenerAddressesToGetConnection(OracleDataSource var1_1) {
        var8_2 = (516L & TraceControllerImpl.feature) != 0L;
        try {
            if (var8_2) {
                ClioSupport.entering(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, new Object[]{var1_1});
            }
            var2_3 = this.listenerAddresses.iterator();
            while (true) {
                block22: {
                    block23: {
                        block20: {
                            block21: {
                                if (!var2_3.hasNext()) {
                                    var9_12 = null;
                                    if (var8_2 == false) return null;
                                    ClioSupport.returning(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, var9_12);
                                    ClioSupport.exiting(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, null);
                                    return null;
                                }
                                listenerAddress = var2_3.next();
                                url = "jdbc:oracle:thin:@(DESCRIPTION=" + listenerAddress + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
                                ods.setURL(url);
                                try {
                                    lock = this.acquireCloseableLock();
                                    try {
                                        if (this.needToBeClosed) {
                                            var6_8 = null;
                                            if (lock != null) {
                                                lock.close();
                                            }
                                            var9_10 = var6_8;
                                            if (!var8_2) break block20;
                                            break block21;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var6_9) {
                                        if (lock != null) {
                                            try {
                                                lock.close();
                                            }
                                            catch (Throwable var7_14) {
                                                var6_9.addSuppressed(var7_14);
                                            }
                                        }
                                        var10_15 = var6_9;
                                        if (var8_2) {
                                            ClioSupport.throwing(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, var10_15);
                                        }
                                        throw var10_15;
                                    }
                                }
                                catch (SQLException var5_7) {
                                    continue;
                                }
                            }
                            ClioSupport.returning(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, var9_10);
                            ClioSupport.exiting(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, null);
                        }
                        return var9_10;
lbl-1000:
                        // 1 sources

                        {
                            notificationConnection = ods.getConnection();
                            if (notificationConnection == null) break block22;
                            var7_13 = notificationConnection;
                            if (lock != null) {
                                lock.close();
                            }
                            var9_11 = var7_13;
                            if (!var8_2) break block23;
                        }
                        ClioSupport.returning(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, var9_11);
                        ClioSupport.exiting(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, null);
                    }
                    return var9_11;
                }
                if (lock == null) continue;
                lock.close();
            }
        }
        catch (Throwable v0) {
            var10_16 = v0;
            if (var8_2) {
                ClioSupport.exiting(NTFJMSConnection.$$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, NTFJMSConnection.$$$methodRef$$$2, this, var10_16);
            }
            throw v0;
        }
    }

    void closeThisListener() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                block16: {
                    this.needToBeClosed = true;
                    try {
                        if (this.oaqnfy != null) {
                            this.oaqnfy.stopListening();
                        }
                        if (this.conn != null) {
                            this.conn.close();
                        }
                    }
                    catch (SQLException ex) {
                        if (!bl) break block16;
                        OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "NTFJMSConnection -, jmsConnectionId = " + this.jmsConnectionId + ", userName = " + this.userName + ": ERROR: got SQLException while closing the connection " + ex.getMessage());
                    }
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setNeedToBeClosed(boolean bl) {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _needToBeClosed;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$4, this, bl);
            }
            this.needToBeClosed = _needToBeClosed;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    String getJMSConnectionId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$5, this, new Object[0]);
            }
            String string = this.jmsConnectionId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$5, this, string);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$5, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    int getNumberOfRegistrations() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$6, this, new Object[0]);
            }
            int n2 = this.numberOfRegistrations;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$6, this, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$6, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void incrementNumberOfRegistrations(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$7, this, n2);
            }
            this.numberOfRegistrations += n3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void decrementNumberOfRegistrations(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$8, this, n2);
            }
            this.numberOfRegistrations -= n3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setConnectionGroup(NTFJMSConnectionGroup nTFJMSConnectionGroup) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _connGroup;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$9, this, nTFJMSConnectionGroup);
            }
            this.connectionGroup = _connGroup;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    NTFJMSConnectionGroup getConnectionGroup() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$10, this, new Object[0]);
            }
            if (this.connectionGroup == null) {
                this.connectionGroup = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
            }
            NTFJMSConnectionGroup nTFJMSConnectionGroup = this.connectionGroup;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$10, this, nTFJMSConnectionGroup);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$10, this, null);
            }
            return nTFJMSConnectionGroup;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$11, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$11, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$11, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = NTFJMSConnection.class.getDeclaredConstructor(String.class, ArrayList.class, String.class, String.class, String.class, OpaqueString.class, Properties.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFJMSConnection.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFJMSConnection.class.getDeclaredMethod("getConnectionGroup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFJMSConnection.class.getDeclaredMethod("setConnectionGroup", NTFJMSConnectionGroup.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFJMSConnection.class.getDeclaredMethod("decrementNumberOfRegistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFJMSConnection.class.getDeclaredMethod("incrementNumberOfRegistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFJMSConnection.class.getDeclaredMethod("getNumberOfRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFJMSConnection.class.getDeclaredMethod("getJMSConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFJMSConnection.class.getDeclaredMethod("setNeedToBeClosed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFJMSConnection.class.getDeclaredMethod("closeThisListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFJMSConnection.class.getDeclaredMethod("tryListenerAddressesToGetConnection", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFJMSConnection.class.getDeclaredMethod("getConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFJMSConnection.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

