/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python;

import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.util.CharsetMapping;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PythonFileDetector
implements TruffleFile.FileTypeDetector {
    private static final String UTF_8_BOM_IN_LATIN_1 = new String(new byte[]{-17, -69, -65}, StandardCharsets.ISO_8859_1);
    private static final Pattern ENCODING_COMMENT = Pattern.compile("^[ \t\f]*#.*?coding[:=][ \t]*([-_.a-zA-Z0-9]+).*");
    private static final Pattern BLANK_LINE = Pattern.compile("^[ \t\f]*(?:#.*)?");

    public String findMimeType(TruffleFile file) throws IOException {
        String fileName = file.getName();
        if (fileName != null && fileName.endsWith(".py")) {
            return "text/x-python";
        }
        return null;
    }

    private static Charset tryGetCharsetFromLine(String line, boolean hasBOM) {
        if (line == null) {
            return null;
        }
        Matcher matcher = ENCODING_COMMENT.matcher(line);
        if (matcher.matches()) {
            String encoding = matcher.group(1);
            TruffleString normalizedEncoding = CharsetMapping.normalizeUncached(PythonUtils.toTruffleStringUncached(encoding));
            if (hasBOM && !normalizedEncoding.equalsUncached((AbstractTruffleString)StringLiterals.T_UTF_UNDERSCORE_8, PythonUtils.TS_ENCODING)) {
                throw new InvalidEncodingException(encoding + " with BOM");
            }
            Charset charset = CharsetMapping.getCharsetNormalized(normalizedEncoding);
            if (charset == null) {
                throw new InvalidEncodingException(encoding);
            }
            return charset;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static Charset findEncodingStrict(BufferedReader reader) throws IOException {
        String firstLine = reader.readLine();
        if (firstLine != null) {
            Charset charset;
            boolean hasBOM = false;
            if (firstLine.startsWith(UTF_8_BOM_IN_LATIN_1)) {
                hasBOM = true;
                firstLine = firstLine.substring(UTF_8_BOM_IN_LATIN_1.length());
            }
            if ((charset = PythonFileDetector.tryGetCharsetFromLine(firstLine, hasBOM)) != null) {
                return charset;
            }
            if (BLANK_LINE.matcher(firstLine).matches() && (charset = PythonFileDetector.tryGetCharsetFromLine(reader.readLine(), hasBOM)) != null) {
                return charset;
            }
        }
        return StandardCharsets.UTF_8;
    }

    @CompilerDirectives.TruffleBoundary
    public static Charset findEncodingStrict(TruffleFile file) throws IOException {
        try (BufferedReader reader = file.newBufferedReader(StandardCharsets.ISO_8859_1);){
            Charset charset = PythonFileDetector.findEncodingStrict(reader);
            return charset;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Charset findEncodingStrict(String source) {
        Charset charset;
        BufferedReader reader = new BufferedReader(new StringReader(source));
        try {
            charset = PythonFileDetector.findEncodingStrict(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return charset;
    }

    @CompilerDirectives.TruffleBoundary
    public static Charset findEncodingStrict(byte[] source, int sourceLen) {
        Charset charset;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(source, 0, sourceLen), StandardCharsets.ISO_8859_1));
        try {
            charset = PythonFileDetector.findEncodingStrict(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return charset;
    }

    public Charset findEncoding(TruffleFile file) throws IOException {
        try {
            return PythonFileDetector.findEncodingStrict(file);
        }
        catch (InvalidEncodingException e) {
            return StandardCharsets.ISO_8859_1;
        }
    }

    public static class InvalidEncodingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String encodingName;

        public InvalidEncodingException(String encodingName) {
            super("Invalid or unsupported encoding: " + encodingName);
            this.encodingName = encodingName;
        }

        public String getEncodingName() {
            return this.encodingName;
        }
    }
}

